/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.resources.resource;

import com.gigaspaces.api.InternalApi;
import java.util.logging.Level;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ResourcePool;
import org.jini.rio.resources.resource.ResourceUnavailableException;

@InternalApi
public class ThreadPool
extends ResourcePool {
    protected ThreadGroup group;
    static int nextID = 0;

    public ThreadPool(String identifier, int min, int max) {
        this.setIdentifier(identifier);
        this.setMin(min);
        this.setMax(max);
        this.group = new ThreadGroup(identifier);
        this.group.setDaemon(true);
        try {
            this.createResources();
        }
        catch (ResourceUnavailableException e) {
            logger.log(Level.SEVERE, "Creating ThreadPool with min=" + min + ", max=" + max, e);
        }
    }

    protected static synchronized int nextId() {
        return nextID++;
    }

    @Override
    protected Object create() throws ResourceUnavailableException {
        PoolableThread thread = new PoolableThread(this);
        thread.setDaemon(true);
        thread.start();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Creating a resource interrupted", e);
        }
        return thread;
    }

    @Override
    protected void dispose(Object obj) {
        if (obj instanceof PoolableThread) {
            PoolableThread thread = (PoolableThread)obj;
            thread.cleanStop();
        }
    }

    @Override
    protected boolean validate(Object obj) {
        return ((PoolableThread)obj).isAlive();
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    public void destroy() {
        block11: {
            int i;
            if (this.group.isDestroyed()) {
                return;
            }
            int activeCount = this.group.activeCount();
            Thread[] activeThreads = new Thread[activeCount];
            int numThreads = this.group.enumerate(activeThreads);
            for (i = 0; i < numThreads; ++i) {
                try {
                    if (activeThreads[i] instanceof PoolableThread) {
                        ((PoolableThread)activeThreads[i]).cleanStop();
                    }
                    activeThreads[i].interrupt();
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Failed to stop active thread " + activeThreads[i].getId(), ex);
                    ex.printStackTrace();
                }
                this.remove(activeThreads[i]);
            }
            this.group.interrupt();
            this.destroyChildGroup(this.group);
            for (i = 0; this.group.activeCount() > 0 && i < 10; ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted while destroying latent Threads", e);
                }
            }
            try {
                if (!this.group.isDestroyed()) {
                    this.group.destroy();
                }
            }
            catch (IllegalThreadStateException e) {
                if (this.group.isDestroyed()) break block11;
                logger.log(Level.WARNING, "IllegalThreadState destroying ThreadGroup", e);
            }
        }
    }

    private void destroyChildGroup(ThreadGroup group) {
        int numChildren = group.activeGroupCount();
        if (numChildren == 0) {
            return;
        }
        ThreadGroup[] children = new ThreadGroup[numChildren];
        int numGroups = group.enumerate(children);
        for (int i = 0; i < numGroups; ++i) {
            children[i].interrupt();
            this.destroyChildGroup(children[i]);
        }
    }

    public static void main(String[] args) {
        try {
            ThreadPool tp = new ThreadPool("Unit Test Thread Pool", 5, 10);
            ThreadGroup group = tp.getThreadGroup();
            group.list();
            tp.destroy();
            group.list();
            tp.get();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

