/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.tools.webster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.nio.filters.BouncyCastleSelfSignedCertificate;
import com.gigaspaces.lrmi.nio.filters.SelfSignedCertificate;
import com.gigaspaces.start.SystemInfo;
import com.sun.jini.start.LifeCycle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.jini.rio.boot.PUZipUtils;
import org.jini.rio.resources.resource.ThreadPool;

@InternalApi
public class Webster
implements Runnable {
    static final int DEFAULT_MIN_THREADS = 0;
    static final int DEFAULT_MAX_THREADS = 10;
    private ServerSocket ss;
    private int port;
    private Thread runner = null;
    private volatile boolean run = true;
    private static Properties MimeTypes = new Properties();
    private String[] websterRoot;
    private ExecutorService pool;
    private int minThreads = 0;
    private int maxThreads = 10;
    private int soTimeout = 0;
    private static Logger logger = Logger.getLogger("org.jini.rio.tools.webster");
    private LifeCycle lifeCycle;
    private boolean debug = false;
    private static String SERVER_DESCRIPTION = Webster.class.getName();
    private boolean restrictAccess;
    private String protocol = "http";
    private static final String WEBSTER_PORT = "org.jini.rio.tools.webster.port";
    private final Object[] putGetZipMutex = new Object[1000];
    private static Random zipFileRandom = new Random();

    public Webster() throws BindException {
        this.port = Integer.getInteger(WEBSTER_PORT, 0);
        this.initialize();
    }

    public Webster(int port) throws BindException {
        this.port = Integer.getInteger(WEBSTER_PORT, 0);
        this.initialize();
    }

    public Webster(String roots) throws BindException {
        this.port = Integer.getInteger(WEBSTER_PORT, 0);
        this.initialize(roots);
    }

    public Webster(int port, String roots) throws BindException {
        this.port = port;
        this.initialize(roots);
    }

    public Webster(int port, String roots, String bindAddress) throws BindException {
        this.port = port;
        this.initialize(roots, bindAddress);
    }

    public Webster(int port, String roots, String bindAddress, int minThreads, int maxThreads) throws BindException {
        this.port = port;
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.initialize(roots, bindAddress);
    }

    public Webster(String[] options, LifeCycle lifeCycle) throws BindException {
        if (options == null) {
            throw new NullPointerException("options are null");
        }
        this.lifeCycle = lifeCycle;
        String roots = null;
        String bindAddress = null;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (option.equals("-port")) {
                this.port = Integer.parseInt(options[++i]);
                continue;
            }
            if (option.equals("-roots")) {
                roots = options[++i];
                continue;
            }
            if (option.equals("-bindAddress")) {
                bindAddress = options[++i];
                continue;
            }
            if (option.equals("-minThreads")) {
                this.minThreads = Integer.parseInt(options[++i]);
                continue;
            }
            if (option.equals("-maxThreads")) {
                this.maxThreads = Integer.parseInt(options[++i]);
                continue;
            }
            if (option.equals("-soTimeout")) {
                this.soTimeout = Integer.parseInt(options[++i]);
                continue;
            }
            throw new IllegalArgumentException(option);
        }
        this.initialize(roots, bindAddress);
    }

    private void initialize() throws BindException {
        String root = System.getProperty("org.jini.rio.tools.webster.root");
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        this.initialize(root);
    }

    private void initialize(String roots) throws BindException {
        this.initialize(roots, null);
    }

    private void initialize(String roots, String bindAddress) throws BindException {
        for (int i = 0; i < this.putGetZipMutex.length; ++i) {
            this.putGetZipMutex[i] = new Object();
        }
        this.restrictAccess = Boolean.parseBoolean(System.getProperty("org.jini.rio.tools.webster.restrictAccess", "true"));
        String d = System.getProperty("org.jini.rio.tools.webster.debug");
        if (d != null) {
            this.debug = true;
        }
        if ((d = System.getProperty("webster.debug")) != null) {
            this.debug = true;
        }
        this.setupRoots(roots);
        ServerSocketFactory serverSocketFactory = null;
        try {
            if (Boolean.getBoolean("org.jini.rio.tools.webster.tls")) {
                if (System.getProperty("javax.net.ssl.keyStore", null) != null) {
                    serverSocketFactory = SSLServerSocketFactory.getDefault();
                } else {
                    KeyStore ks = this.keystore();
                    if (ks != null) {
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(ks, "foo".toCharArray());
                        sslContext.init(kmf.getKeyManagers(), null, null);
                        serverSocketFactory = sslContext.getServerSocketFactory();
                    }
                }
                this.protocol = "https";
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Failed to create TLS connection", e);
        }
        if (serverSocketFactory == null) {
            serverSocketFactory = ServerSocketFactory.getDefault();
        }
        try {
            if (bindAddress == null) {
                this.ss = serverSocketFactory.createServerSocket(this.port);
            } else {
                InetAddress addr = InetAddress.getByName(bindAddress);
                this.ss = serverSocketFactory.createServerSocket(this.port, 0, addr);
            }
            this.port = this.ss.getLocalPort();
            if (logger.isLoggable(Level.FINE) || this.debug) {
                String msg = "Webster serving on : " + this.ss.getInetAddress().getHostAddress() + ":" + this.port;
                if (this.debug) {
                    System.out.println(msg);
                }
                logger.fine(msg);
            }
        }
        catch (BindException be) {
            this.logAndThrowBindExceptionException(bindAddress, be);
        }
        catch (IOException ioe) {
            BindException be = new BindException("Could not start listener. Port [" + this.port + "] already taken");
            be.initCause(ioe);
            this.logAndThrowBindExceptionException(bindAddress, be);
        }
        try {
            this.pool = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("GS-Webster" + t.getName());
                    t.setDaemon(true);
                    return t;
                }
            });
            new ThreadPool("Webster", this.minThreads, this.maxThreads);
            if (this.debug) {
                System.out.println("Webster minThreads [" + this.minThreads + "], maxThreads [" + this.maxThreads + "]");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Webster minThreads [" + this.minThreads + "], maxThreads [" + this.maxThreads + "]");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not create ThreadPool", e);
            throw new RuntimeException("Could not create Thread Pool");
        }
        if (this.soTimeout > 0) {
            if (this.debug) {
                System.out.println("Webster Socket SO_TIMEOUT set to [" + this.soTimeout + "] millis");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Webster Socket SO_TIMEOUT set to [" + this.soTimeout + "] millis");
            }
        }
        this.runner = new GSThread(this, "Webster Runner");
        this.runner.setDaemon(true);
        this.runner.start();
    }

    private KeyStore keystore() {
        try {
            return SelfSignedCertificate.keystore();
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Failed to create self signed certificate using sun classes will try Bouncy Castle.", e);
            } else if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Could not create self signed certificate using sun classes - trying Bouncy Castle");
            }
            try {
                return BouncyCastleSelfSignedCertificate.keystore();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Failed to create self signed certificate using Bouncy Castle classes.\n please add Bouncy Castle jars to classpath (or add the artifact org.bouncycastle.bcpkix-jdk15on to maven)", t);
                return null;
            }
        }
    }

    private void logAndThrowBindExceptionException(String bindAddress, BindException be) throws BindException {
        String hostAddress = SystemInfo.singleton().network().getHostId();
        if (bindAddress == null) {
            logger.log(Level.WARNING, "Failed to bind socket on [" + hostAddress + "], port [" + this.port + "], please check your network configuration", be);
        } else {
            logger.log(Level.WARNING, "Failed to bind socket on [" + hostAddress + "], bind address [" + bindAddress + "], port [" + this.port + "], please check your network configuration", be);
        }
        throw be;
    }

    public String getRoots() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.websterRoot.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.websterRoot[i]);
        }
        return buffer.toString();
    }

    public String getURL() {
        return this.getProtocol() + "://" + this.getAddress() + ":" + this.getPort() + "/";
    }

    public String getAddress() {
        if (this.ss == null) {
            return null;
        }
        InetAddress inetAddress = SystemInfo.singleton().network().isPublicHostConfigured() ? SystemInfo.singleton().network().getPublicHost() : this.ss.getInetAddress();
        return BootIOUtils.wrapIpv6HostAddressIfNeeded(inetAddress);
    }

    public String getHostName() {
        return this.ss == null ? null : this.ss.getInetAddress().getHostName();
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void setupRoots(String roots) {
        if (roots == null) {
            throw new NullPointerException("roots is null");
        }
        StringTokenizer tok = new StringTokenizer(roots, ";");
        this.websterRoot = new String[tok.countTokens()];
        if (this.websterRoot.length > 1) {
            for (int j = 0; j < this.websterRoot.length; ++j) {
                this.websterRoot[j] = tok.nextToken();
                if (this.debug) {
                    System.out.println("Root " + j + " = " + this.websterRoot[j]);
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Root " + j + " = " + this.websterRoot[j]);
            }
        } else {
            this.websterRoot[0] = roots;
            if (this.debug) {
                System.out.println("Root  = " + this.websterRoot[0]);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Root  = " + this.websterRoot[0]);
            }
        }
    }

    public void terminate() {
        this.run = false;
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception closing Webster ServerSocket", e);
            }
        }
        if (this.lifeCycle != null) {
            this.lifeCycle.unregister(this);
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    public int getPort() {
        return this.port;
    }

    private boolean readLine(InputStream in, StringBuffer buf) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c == 13) {
                in.mark(1);
                c = in.read();
                if (c != 10) {
                    in.reset();
                }
                return true;
            }
            if (c == 10) {
                return true;
            }
            buf.append((char)c);
        }
        return buf.length() > 0;
    }

    private String getRequest(BufferedInputStream in) throws IOException {
        StringBuffer buf = new StringBuffer(80);
        do {
            if (this.readLine(in, buf)) continue;
            return null;
        } while (buf.length() == 0);
        String req = buf.toString();
        do {
            buf.setLength(0);
        } while (this.readLine(in, buf) && buf.length() > 0);
        return req;
    }

    private String getRequestLine(BufferedInputStream in) throws IOException {
        StringBuffer buf = new StringBuffer(80);
        do {
            if (this.readLine(in, buf)) continue;
            return null;
        } while (buf.length() == 0);
        return buf.toString();
    }

    private String getNextRequestLine(BufferedInputStream in) throws IOException {
        StringBuffer buf = new StringBuffer(80);
        if (!this.readLine(in, buf)) {
            return null;
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block41: {
            Socket s = null;
            try {
                this.loadMimes();
                String fileName = null;
                while (this.run) {
                    s = this.ss.accept();
                    if (this.soTimeout > 0) {
                        s.setSoTimeout(this.soTimeout);
                    }
                    BufferedInputStream in = new BufferedInputStream(s.getInputStream());
                    String line = null;
                    Properties header = new Properties();
                    try {
                        StringBuffer buff;
                        line = this.getRequestLine(in);
                        int port = s.getPort();
                        String from = s.getInetAddress().getHostAddress() + ":" + port;
                        if (this.debug) {
                            buff = new StringBuffer();
                            buff.append("From: " + from + ", ");
                            if (this.soTimeout > 0) {
                                buff.append("SO_TIMEOUT: " + this.soTimeout + ", ");
                            }
                            buff.append("Request: " + line);
                            System.out.println(buff.toString());
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            buff = new StringBuffer();
                            buff.append("From: " + from + ", ");
                            if (this.soTimeout > 0) {
                                buff.append("SO_TIMEOUT: " + this.soTimeout + ", ");
                            }
                            buff.append("Request: " + line);
                            logger.fine(buff.toString());
                        }
                        if (line == null) continue;
                        StringTokenizer tokenizer = new StringTokenizer(line, " ");
                        if (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            fileName = tokenizer.nextToken();
                            if (fileName.startsWith("/")) {
                                fileName = fileName.substring(1);
                            }
                            if (token.equals("GET")) {
                                header.setProperty("GET", fileName);
                            } else if (token.equals("PUT")) {
                                header.setProperty("PUT", fileName);
                            } else if (token.equals("DELETE")) {
                                header.setProperty("DELETE", fileName);
                            } else if (token.equals("HEAD")) {
                                header.setProperty("HEAD", fileName);
                            }
                            while ((line = this.getNextRequestLine(in)) != null) {
                                int colIdx = line.indexOf(58);
                                if (colIdx <= 0) continue;
                                String key = line.substring(0, colIdx);
                                String value = line.substring(colIdx + 1);
                                header.setProperty(key.trim(), value.trim());
                            }
                            if (this.restrictAccess && fileName.indexOf("..") != -1) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "forbidden [" + line + "] from " + from);
                                }
                                DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                                clientStream.writeBytes("HTTP/1.0 403 Forbidden\r\n\r\n");
                                clientStream.flush();
                                clientStream.close();
                                try {
                                    s.close();
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (header.getProperty("GET") != null) {
                                this.pool.execute(new GetFile(s, fileName, header));
                                continue;
                            }
                            if (header.getProperty("PUT") != null) {
                                this.pool.execute(new PutFile(in, s, fileName, header));
                                continue;
                            }
                            if (header.getProperty("DELETE") != null) {
                                throw new IOException("DELETE not allowed");
                            }
                            if (header.getProperty("HEAD") != null) {
                                this.pool.execute(new Head(s, fileName, header));
                                continue;
                            }
                            if (this.debug) {
                                System.out.println("bad request [" + line + "] from " + from);
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "bad request [" + line + "] from " + from);
                            }
                            DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                            clientStream.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                            clientStream.flush();
                            clientStream.close();
                        }
                        break;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Getting Request from " + s.getInetAddress() + ":" + s.getPort(), e);
                        FilterOutputStream clientStream = null;
                        try {
                            clientStream = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                            ((DataOutputStream)clientStream).writeBytes("HTTP/1.0 500 Internal Server Error\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\n\n\n<H1>500 Internal Server Error</H1>\n" + e);
                            ((DataOutputStream)clientStream).flush();
                        }
                        catch (Exception e1) {
                            logger.log(Level.WARNING, "Failed to send 500 response", e);
                        }
                        finally {
                            try {
                                if (clientStream == null) continue;
                                clientStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!this.run) break block41;
                e.printStackTrace();
                logger.log(Level.WARNING, "Processing HTTP Request", e);
            }
        }
    }

    void loadMimes() throws IOException {
        ClassLoader ccl;
        URL fileURL;
        boolean loadDefaults = true;
        if (this.debug) {
            System.out.println("Loading mimetypes ... ");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading mimetypes ... ");
        }
        URL uRL = fileURL = (ccl = Thread.currentThread().getContextClassLoader()) != null ? ccl.getResource("org/jini/rio/tools/webster/mimetypes.properties") : null;
        if (fileURL != null) {
            try {
                InputStream is = fileURL.openStream();
                MimeTypes.load(is);
                is.close();
                loadDefaults = false;
                if (this.debug) {
                    System.out.println("Mimetypes loaded");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Mimetypes loaded");
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Loading Mimetypes", ioe);
            }
        } else {
            if (loadDefaults) {
                if (this.debug) {
                    System.out.println("mimetypes.properties not found, loading defaults");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("mimetypes.properties not found, loading defaults");
                }
            }
            MimeTypes.put("jpg", "image/jpg");
            MimeTypes.put("jpeg", "image/jpg");
            MimeTypes.put("jpe", "image/jpg");
            MimeTypes.put("gif", "image/gif");
            MimeTypes.put("htm", "text/html");
            MimeTypes.put("html", "text/html");
            MimeTypes.put("txt", "text/plain");
            MimeTypes.put("qt", "video/quicktime");
            MimeTypes.put("mov", "video/quicktime");
            MimeTypes.put("class", "application/octet-stream");
            MimeTypes.put("mpg", "video/mpeg");
            MimeTypes.put("mpeg", "video/mpeg");
            MimeTypes.put("mpe", "video/mpeg");
            MimeTypes.put("au", "audio/basic");
            MimeTypes.put("snd", "audio/basic");
            MimeTypes.put("wav", "audio/x-wave");
            MimeTypes.put("JNLP", "application/x-java-jnlp-file");
            MimeTypes.put("jnlp", "application/x-java-jnlp-file");
            MimeTypes.put("java", "application/java");
            MimeTypes.put("jar", "application/java");
            MimeTypes.put("JAR", "application/java");
        }
    }

    protected File parseFileName(String filename) {
        StringBuffer fn = new StringBuffer(filename);
        for (int i = 0; i < fn.length(); ++i) {
            if (fn.charAt(i) != '/') continue;
            fn.replace(i, i + 1, File.separator);
        }
        File f = null;
        String[] roots = this.expandRoots();
        for (int i = 0; i < roots.length; ++i) {
            f = new File(roots[i], fn.toString());
            if (!f.exists()) continue;
            return f;
        }
        return f;
    }

    protected String[] expandRoots() {
        LinkedList<String> expandedRoots = new LinkedList<String>();
        if (this.hasWildcard()) {
            String[] rawRoots = this.websterRoot;
            for (int i = 0; i < rawRoots.length; ++i) {
                String root = rawRoots[i];
                int wildcard = root.indexOf(42);
                if (wildcard != -1) {
                    String prefix = root.substring(0, wildcard);
                    File prefixFile = new File(prefix);
                    if (!prefixFile.exists()) continue;
                    String suffix = wildcard < root.length() - 1 ? root.substring(wildcard + 1) : "";
                    String[] children = prefixFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        expandedRoots.add(prefix + children[j] + suffix);
                    }
                    continue;
                }
                expandedRoots.add(rawRoots[i]);
            }
        }
        String[] roots = null;
        roots = expandedRoots.size() > 0 ? expandedRoots.toArray(new String[expandedRoots.size()]) : this.websterRoot;
        return roots;
    }

    boolean hasWildcard() {
        boolean wildcarded = false;
        for (int i = 0; i < this.websterRoot.length; ++i) {
            String root = this.websterRoot[i];
            if (root.indexOf(42) == -1) continue;
            wildcarded = true;
            break;
        }
        return wildcarded;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("start webster");
        System.setProperty("org.jini.rio.tools.webster.tls", "true");
        try {
            Webster webster = new Webster(8080, "/home/barakbo/tmp/setups/gigaspaces-xap-premium-11.0.0-m7/bin");
            webster.debug = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.in.read();
        System.out.println("webster exiting");
    }

    public static boolean deleteFile(File dir) {
        String[] children;
        if (!dir.exists()) {
            return true;
        }
        boolean globalSuccess = true;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = Webster.deleteFile(new File(dir, children[i]));
                if (success) continue;
                globalSuccess = false;
            }
        }
        if (!dir.delete()) {
            globalSuccess = false;
        }
        return globalSuccess;
    }

    class DelFile
    implements Runnable {
        private final Socket client;
        private final String fileName;
        private String header;

        DelFile(Socket s, String fileName, Properties header) {
            this.client = s;
            this.fileName = fileName;
        }

        @Override
        public void run() {
            try {
                File putFile = Webster.this.parseFileName(this.fileName);
                this.header = !putFile.exists() ? "HTTP/1.0 404 File not found\nAllow: GET\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\n\n\n <H1>404 File not Found</H1>\n<BR>" : (putFile.delete() ? "HTTP/1.0 200 OK\nAllow: PUT\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\n\n\n <H1>200 File successfully deleted</H1>\n" : "HTTP/1.0 500 Internal Server Error\nAllow: PUT\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\n\n\n <H1>500 File could not be deleted</H1>\n");
                DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
                clientStream.writeBytes(this.header);
                clientStream.flush();
                clientStream.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Closing Socket", e);
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Closing incoming socket", e2);
                }
            }
        }
    }

    class PutFile
    implements Runnable {
        private final Socket client;
        private final BufferedInputStream in;
        private final String fileName;
        private String header;
        private final Properties rheader;

        PutFile(BufferedInputStream in, Socket s, String fileName, Properties header) {
            this.in = in;
            this.rheader = header;
            this.client = s;
            this.fileName = fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File putFile = Webster.this.parseFileName(this.fileName);
                this.header = putFile.exists() ? "HTTP/1.0 200 OK\r\nAllow: PUT\r\nMIME-Version: 1.0\r\nServer : Webster: a Java HTTP Server \r\n\r\n\r\n\n\n <H1>200 File updated</H1>\n" : "HTTP/1.0 201 Created\r\nAllow: PUT\r\nMIME-Version: 1.0\r\nServer : Webster: a Java HTTP Server \r\n\r\n\r\n\n\n <H1>201 File Created</H1>\n";
                String putFileName = putFile.getName();
                if (putFileName.length() >= 4 && putFileName.charAt(putFileName.length() - 4) == '.') {
                    putFileName = putFileName.substring(0, putFileName.length() - 4);
                }
                Object object = Webster.this.putGetZipMutex[Math.abs(putFileName.hashCode() % Webster.this.putGetZipMutex.length)];
                synchronized (object) {
                    block37: {
                        BufferedOutputStream requestedFile = new BufferedOutputStream(new FileOutputStream(putFile));
                        try {
                            String extract = this.ignoreCaseProperty(this.rheader, "Extract");
                            if (!"true".equalsIgnoreCase(extract)) {
                                throw new IOException("PUT is not allowed");
                            }
                            int length = Integer.parseInt(this.ignoreCaseProperty(this.rheader, "Content-Length"));
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Putting file [" + putFile.getAbsolutePath() + "] with length [" + length + "]");
                            }
                            for (int i = 0; i < length; ++i) {
                                ((OutputStream)requestedFile).write(this.in.read());
                            }
                            ((OutputStream)requestedFile).flush();
                            ((OutputStream)requestedFile).close();
                            if (extract == null || !extract.equalsIgnoreCase("true")) break block37;
                            File directory = putFile.getParentFile();
                            String prefix = putFileName;
                            String suffix = "";
                            File tempDestDir = File.createTempFile(prefix, suffix, directory);
                            this.deleteFileWithRetry(tempDestDir);
                            tempDestDir.mkdirs();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Extracting file [" + putFile.getAbsolutePath() + "] to [" + tempDestDir.getAbsolutePath() + "]");
                            }
                            PUZipUtils.unzip(putFile, tempDestDir);
                            this.deleteFileWithRetry(putFile);
                            File oldDestDir = File.createTempFile(prefix + "_old_", suffix, directory);
                            this.deleteFileWithRetry(oldDestDir);
                            File destDir = new File(putFile.getParentFile(), putFileName);
                            if (destDir.exists()) {
                                try {
                                    this.renameFile(destDir, oldDestDir);
                                }
                                catch (IOException e) {
                                    if (logger.isLoggable(Level.WARNING)) {
                                        logger.log(Level.WARNING, "Failed to rename " + destDir + " will try to delete it instead. This could happen on Windows if " + destDir + " is still locked by another process.", e);
                                    }
                                    this.deleteFileWithRetry(destDir);
                                }
                            }
                            this.renameFile(tempDestDir, destDir);
                            try {
                                this.deleteFileWithRetry(oldDestDir);
                            }
                            catch (IOException e) {
                                if (logger.isLoggable(Level.WARNING)) {
                                    logger.log(Level.WARNING, "Failed to delete temp folder " + oldDestDir + " Will try to delete it after this process exists.", e);
                                }
                                destDir.deleteOnExit();
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Failed to write file [" + this.fileName + "]", e);
                            this.header = "HTTP/1.0 500 Internal Server Error\r\nAllow: PUT\r\nMIME-Version: 1.0\r\nServer: " + SERVER_DESCRIPTION + "\r\n\r\n\r\n\n\n <H1>500 Internal Server Error</H1>\n" + e;
                        }
                        finally {
                            try {
                                ((OutputStream)requestedFile).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
                clientStream.writeBytes(this.header);
                clientStream.flush();
                clientStream.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Closing Socket", e);
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Closing incoming socket", e2);
                }
            }
        }

        private void renameFile(File srcDir, File targetDir) throws IOException {
            boolean success;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Renaming " + srcDir + " to " + targetDir);
            }
            if (!(success = srcDir.renameTo(targetDir))) {
                throw new IOException("Renaming " + srcDir + " to " + targetDir + " failed.");
            }
        }

        private void deleteFileWithRetry(File file) throws IOException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Trying to delete " + file);
            }
            boolean deleted = false;
            for (int i = 0; i < 5 && !(deleted = Webster.deleteFile(file)); ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!deleted) {
                throw new IOException("Failed to delete [" + file.getAbsolutePath() + "]");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deleted " + file);
            }
        }

        public String ignoreCaseProperty(Properties props, String field) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String propName = (String)names.nextElement();
                if (!field.equalsIgnoreCase(propName)) continue;
                return props.getProperty(propName);
            }
            return null;
        }
    }

    class GetFile
    implements Runnable {
        private final Socket client;
        private final String fileName;
        private String header;
        private DataInputStream requestedFile;
        private long fileLength;
        private final Properties rheader;

        GetFile(Socket s, String fileName, Properties header) {
            this.client = s;
            this.fileName = fileName;
            this.rheader = header;
        }

        public String ignoreCaseProperty(Properties props, String field) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String propName = (String)names.nextElement();
                if (!field.equalsIgnoreCase(propName)) continue;
                return props.getProperty(propName);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder dirData = new StringBuilder();
            StringBuilder logData = new StringBuilder();
            try {
                String packageDir;
                File rootFile;
                Object root;
                int i;
                ArrayList<File> filesList;
                File[] files = null;
                if (this.fileName.equals("") || this.fileName.equals("/")) {
                    logData.append("Do GET: input=" + this.fileName + ", list roots, ");
                    filesList = new ArrayList();
                    for (i = 0; i < Webster.this.websterRoot.length; ++i) {
                        root = Webster.this.websterRoot[i];
                        rootFile = new File((String)root);
                        filesList.addAll(Arrays.asList(BootIOUtils.listFiles(rootFile)));
                    }
                    files = filesList.toArray(new File[filesList.size()]);
                } else if (this.fileName.equals("list-pu")) {
                    filesList = new ArrayList<File>();
                    for (i = 0; i < Webster.this.websterRoot.length; ++i) {
                        root = Webster.this.websterRoot[i];
                        rootFile = new File((String)root);
                        File[] pus = BootIOUtils.listFiles(rootFile, new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                if (!pathname.isDirectory()) {
                                    return false;
                                }
                                return new File(pathname, "META-INF/spring/pu.xml").exists() || new File(pathname, "WEB-INF/web.xml").exists() || new File(pathname, "pu.config").exists() || new File(pathname, "pu.interop.config").exists();
                            }
                        });
                        filesList.addAll(Arrays.asList(pus));
                    }
                    files = filesList.toArray(new File[filesList.size()]);
                }
                File getFile = null;
                if (files == null) {
                    getFile = Webster.this.parseFileName(this.fileName);
                    logData.append("Do GET: input=" + this.fileName + ", parsed=" + getFile + ", ");
                    if (getFile.isDirectory()) {
                        files = BootIOUtils.listFiles(getFile);
                    }
                }
                if ((packageDir = this.ignoreCaseProperty(this.rheader, "Package")) != null && "true".equalsIgnoreCase(packageDir)) {
                    root = Webster.this.putGetZipMutex[Math.abs(getFile.getName().hashCode() % Webster.this.putGetZipMutex.length)];
                    synchronized (root) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Received GET operation for packaged processing unit [" + getFile.getName() + "]");
                        }
                        if (getFile.exists()) {
                            File packagedZip;
                            if (!getFile.isDirectory()) {
                                throw new IOException("Trying to package a file [" + getFile.getAbsolutePath() + "] that is not a directory");
                            }
                            File tempLocation = new File(System.getProperty("com.gs.work", SystemInfo.singleton().getXapHome() + "/work/webster"));
                            tempLocation.mkdirs();
                            try {
                                String name = getFile.getName();
                                packagedZip = new File(tempLocation, name + zipFileRandom.nextLong() + ".zip");
                            }
                            catch (Exception e) {
                                IOException ioe = new IOException("Failed to create temporary zip file at [" + tempLocation.getAbsolutePath() + "] from [" + getFile.getAbsolutePath() + "]");
                                ioe.initCause(e);
                                throw ioe;
                            }
                            try {
                                PUZipUtils.zip(getFile, packagedZip);
                            }
                            catch (Exception e) {
                                IOException ioe = new IOException("Failed to build temporary zip file at [" + packagedZip.getAbsolutePath() + "] from [" + getFile.getAbsolutePath() + "]");
                                ioe.initCause(e);
                                throw ioe;
                            }
                            getFile = packagedZip;
                            RandomAccessFile ras = new RandomAccessFile(packagedZip, "rw");
                            ras.getFD().sync();
                            ras.close();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Created temporary packaged (zip) processing unit to send back at [" + getFile.getAbsolutePath() + "] with size [" + getFile.length() + "]");
                            }
                            files = null;
                        }
                    }
                }
                if (files != null) {
                    String list = this.ignoreCaseProperty(this.rheader, "list");
                    if (!this.fileName.equals("list-pu") && !"true".equals(list)) {
                        dirData.append("");
                    } else {
                        logData.append("directory located");
                        for (int i2 = 0; i2 < files.length; ++i2) {
                            File f = files[i2];
                            dirData.append(URLEncoder.encode(f.getName().trim(), "UTF-8"));
                            dirData.append("\t");
                            if (f.isDirectory()) {
                                dirData.append("d");
                            } else {
                                dirData.append("f");
                            }
                            dirData.append("\t");
                            dirData.append(f.length());
                            dirData.append("\t");
                            dirData.append(f.lastModified());
                            dirData.append("\n");
                        }
                    }
                    this.fileLength = dirData.length();
                    String fileType = MimeTypes.getProperty("txt");
                    if (fileType == null) {
                        fileType = "application/java";
                    }
                    this.header = "HTTP/1.0 200 OK\nAllow: GET\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\nContent-Type: " + fileType + "\nContent-Length: " + this.fileLength + "\r\n\r\n";
                } else if (getFile.exists()) {
                    this.requestedFile = new DataInputStream(new BufferedInputStream(new FileInputStream(getFile)));
                    this.fileLength = getFile.length();
                    String fileType = this.fileName.substring(this.fileName.lastIndexOf(".") + 1, this.fileName.length());
                    fileType = MimeTypes.getProperty(fileType);
                    this.header = "HTTP/1.0 200 OK\nAllow: GET\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\nContent-Type: " + fileType + "\nContent-Length: " + this.fileLength + "\r\n\r\n";
                } else {
                    this.header = "HTTP/1.0 404 Not Found\r\n\r\n";
                }
                DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
                clientStream.writeBytes(this.header);
                if (files != null) {
                    clientStream.writeBytes(dirData.toString());
                } else if (getFile.exists()) {
                    block51: {
                        byte[] buffer = new byte[4096];
                        int bytesRead = -1;
                        try {
                            while ((bytesRead = this.requestedFile.read(buffer)) != -1) {
                                clientStream.write(buffer, 0, bytesRead);
                            }
                        }
                        catch (Exception e) {
                            String s = "Sending [" + getFile.getAbsolutePath() + "], size [" + this.fileLength + "], to client at [" + this.client.getInetAddress().getHostAddress() + "]";
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, s, e);
                            }
                            if (!Webster.this.debug) break block51;
                            System.out.println(s);
                            e.printStackTrace();
                        }
                    }
                    this.requestedFile.close();
                    if (packageDir != null && "true".equalsIgnoreCase(packageDir)) {
                        getFile.delete();
                    }
                } else {
                    logData.append("not found");
                }
                if (Webster.this.debug) {
                    System.out.println(logData.toString());
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(logData.toString());
                }
                clientStream.flush();
                clientStream.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "GET operation failed for [" + this.fileName + "]", e);
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Closing incoming socket", e2);
                }
            }
        }
    }

    class Head
    implements Runnable {
        private final Socket client;
        private final String fileName;
        private String header;
        private DataInputStream requestedFile;
        private int fileLength;

        Head(Socket s, String fileName, Properties header) {
            this.client = s;
            this.fileName = fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer dirData = new StringBuffer();
            StringBuffer logData = new StringBuffer();
            try {
                File getFile = Webster.this.parseFileName(this.fileName);
                logData.append("Do HEAD: input=" + this.fileName + ", parsed=" + getFile + ", ");
                if (getFile.isDirectory()) {
                    logData.append("directory located");
                    String[] files = getFile.list();
                    for (int i = 0; i < files.length; ++i) {
                        File f = new File(getFile, files[i]);
                        dirData.append(f.toString().substring(getFile.getParent().length()));
                        dirData.append("\t");
                        if (f.isDirectory()) {
                            dirData.append("d");
                        } else {
                            dirData.append("f");
                        }
                        dirData.append("\t");
                        dirData.append(f.length());
                        dirData.append("\t");
                        dirData.append(f.lastModified());
                        dirData.append("\n");
                    }
                    this.fileLength = dirData.length();
                    String fileType = MimeTypes.getProperty("txt");
                    if (fileType == null) {
                        fileType = "application/java";
                    }
                    this.header = "HTTP/1.0 200 OK\nAllow: GET\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\nContent-Type: " + fileType + "\nContent-Length: " + this.fileLength + "\r\n\r\n";
                } else if (getFile.exists()) {
                    this.requestedFile = new DataInputStream(new BufferedInputStream(new FileInputStream(getFile)));
                    this.fileLength = this.requestedFile.available();
                    String fileType = this.fileName.substring(this.fileName.lastIndexOf(".") + 1, this.fileName.length());
                    fileType = MimeTypes.getProperty(fileType);
                    logData.append("file size: [" + this.fileLength + "]");
                    this.header = "HTTP/1.0 200 OK\nAllow: GET\nMIME-Version: 1.0\nServer: " + SERVER_DESCRIPTION + "\nContent-Type: " + fileType + "\nContent-Length: " + this.fileLength + "\r\n\r\n";
                } else {
                    this.header = "HTTP/1.1 404 Not Found\r\n\r\n";
                    logData.append("not found");
                }
                if (Webster.this.debug) {
                    System.out.println(logData.toString());
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(logData.toString());
                }
                DataOutputStream clientStream = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
                clientStream.writeBytes(this.header);
                clientStream.flush();
                clientStream.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error closing Socket", e);
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Closing incoming socket", e2);
                }
            }
        }
    }
}

