/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.PreparedQueryImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.CacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedQueryCacheImpl
implements PreparedQueryCache {
    private static final String PATTERN_SEPARATOR = "\\;";
    private final Map<String, PreparedQuery> _delegate;
    private final Map<String, PreparedQueryCache.Exclusion> _uncachables;
    private final List<PreparedQueryCache.Exclusion> _exclusionPatterns;
    private QueryStatistics<String> _stats;
    private boolean _statsEnabled;
    private ReentrantLock _lock = new ReentrantLock();
    private Log _log;
    private static Localizer _loc = Localizer.forPackage(PreparedQueryCacheImpl.class);

    public PreparedQueryCacheImpl() {
        this._delegate = new CacheMap();
        this._uncachables = new CacheMap();
        this._exclusionPatterns = new ArrayList<PreparedQueryCache.Exclusion>();
    }

    @Override
    public Boolean register(String id, Query query, FetchConfiguration hints) {
        if (id == null || query == null || "openjpa.SQL".equals(query.getLanguage()) || "openjpa.MethodQL".equals(query.getLanguage()) || this.isHinted(hints, "openjpa.hint.IgnorePreparedQuery") || this.isHinted(hints, "openjpa.hint.InvalidatePreparedQuery")) {
            return Boolean.FALSE;
        }
        if (this.isCachable(id) == Boolean.FALSE) {
            return Boolean.FALSE;
        }
        PreparedQuery cached = this.get(id);
        if (cached != null) {
            return null;
        }
        PreparedQueryImpl newEntry = new PreparedQueryImpl(id, query);
        return this.cache(newEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMapView() {
        this.lock();
        try {
            TreeMap<String, String> view = new TreeMap<String, String>();
            for (Map.Entry<String, PreparedQuery> entry : this._delegate.entrySet()) {
                view.put(entry.getKey(), entry.getValue().getTargetQuery());
            }
            TreeMap<String, String> treeMap = view;
            return treeMap;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cache(PreparedQuery q) {
        this.lock();
        try {
            String id = q.getIdentifier();
            if (this.isCachable(id) == Boolean.FALSE) {
                if (this._log != null && this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("prepared-query-not-cachable", id));
                }
                boolean bl = false;
                return bl;
            }
            PreparedQueryCache.Exclusion exclusion = this.getMatchedExclusionPattern(id);
            if (exclusion != null) {
                this.markUncachable(id, exclusion);
                boolean bl = false;
                return bl;
            }
            this._delegate.put(id, q);
            if (this._log != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("prepared-query-cached", id));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedQuery initialize(String key, Object result) {
        PreparedQuery pq = this.get(key);
        if (pq == null) {
            return null;
        }
        PreparedQueryCache.Exclusion exclusion = pq.initialize(result);
        if (exclusion != null) {
            this.markUncachable(key, exclusion);
            return null;
        }
        return pq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invalidate(String id) {
        this.lock();
        try {
            if (this._log != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("prepared-query-invalidate", id));
            }
            boolean bl = this._delegate.remove(id) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedQuery get(String id) {
        this.lock();
        try {
            PreparedQuery preparedQuery = this._delegate.get(id);
            return preparedQuery;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isCachable(String id) {
        this.lock();
        try {
            if (this._uncachables.containsKey(id)) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (this._delegate.containsKey(id)) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            Boolean bl = null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedQuery markUncachable(String id, PreparedQueryCache.Exclusion exclusion) {
        this.lock();
        try {
            if (this._uncachables.put(id, exclusion) == null && this._log != null && this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("prepared-query-uncache", id, exclusion));
            }
            PreparedQuery preparedQuery = this._delegate.remove(id);
            return preparedQuery;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedQueryCache.Exclusion isExcluded(String id) {
        return this.getMatchedExclusionPattern(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExcludes(String excludes) {
        this.lock();
        try {
            String[] patterns;
            if (StringUtils.isEmpty((String)excludes)) {
                return;
            }
            for (String pattern : patterns = excludes.split(PATTERN_SEPARATOR)) {
                this.addExclusionPattern(pattern);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public List<PreparedQueryCache.Exclusion> getExcludes() {
        return Collections.unmodifiableList(this._exclusionPatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExclusionPattern(String pattern) {
        this.lock();
        try {
            String reason = _loc.get("prepared-query-excluded-by-user", pattern).getMessage();
            WeakExclusion exclusion = new WeakExclusion(pattern, reason);
            this._exclusionPatterns.add(exclusion);
            Collection<String> invalidKeys = this.getMatchedKeys(pattern, this._delegate.keySet());
            for (String invalidKey : invalidKeys) {
                WeakExclusion invalid = new WeakExclusion(invalidKey, reason);
                this.markUncachable(invalidKey, invalid);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExclusionPattern(String pattern) {
        this.lock();
        try {
            WeakExclusion exclusion = new WeakExclusion(pattern, null);
            this._exclusionPatterns.remove(exclusion);
            Collection<String> reborns = this.getMatchedKeys(pattern, this._uncachables);
            for (String rebornKey : reborns) {
                this._uncachables.remove(rebornKey);
                if (this._log == null || !this._log.isTraceEnabled()) continue;
                this._log.trace(_loc.get("prepared-query-remove-pattern", pattern, rebornKey));
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public QueryStatistics<String> getStatistics() {
        return this._stats;
    }

    private PreparedQueryCache.Exclusion getMatchedExclusionPattern(String id) {
        for (PreparedQueryCache.Exclusion pattern : this._exclusionPatterns) {
            if (!pattern.matches(id)) continue;
            return pattern;
        }
        return null;
    }

    private Collection<String> getMatchedKeys(String pattern, Map<String, PreparedQueryCache.Exclusion> map) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, PreparedQueryCache.Exclusion> entry : map.entrySet()) {
            PreparedQueryCache.Exclusion exclusion = entry.getValue();
            if (exclusion.isStrong() || !exclusion.matches(pattern)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Collection<String> getMatchedKeys(String pattern, Collection<String> coll) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : coll) {
            if (!this.matches(pattern, key)) continue;
            result.add(key);
        }
        return result;
    }

    void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    void unlock() {
        if (this._lock != null && this._lock.isLocked()) {
            this._lock.unlock();
        }
    }

    boolean matches(String pattern, String target) {
        return target != null && (target.equals(pattern) || target.matches(pattern));
    }

    boolean isHinted(FetchConfiguration fetch, String hint) {
        if (fetch == null) {
            return false;
        }
        Object result = fetch.getHint(hint);
        return result != null && "true".equalsIgnoreCase(result.toString());
    }

    @Override
    public void clear() {
        this._delegate.clear();
        this._stats.clear();
    }

    @Override
    public void setEnableStatistics(boolean enable) {
        this._statsEnabled = enable;
    }

    @Override
    public boolean getEnableStatistics() {
        return this._statsEnabled;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._log = conf.getLog("openjpa.Runtime");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this._stats = this._statsEnabled ? new QueryStatistics.Default() : new QueryStatistics.None();
    }

    public static class WeakExclusion
    extends ExclusionPattern {
        public WeakExclusion(String pattern, String reason) {
            super(false, pattern, reason);
        }
    }

    public static class StrongExclusion
    extends ExclusionPattern {
        public StrongExclusion(String pattern, String reason) {
            super(true, pattern, reason);
        }
    }

    private static abstract class ExclusionPattern
    implements PreparedQueryCache.Exclusion {
        private final boolean _strong;
        private final String _pattern;
        private final String _reason;
        private static Localizer _loc = Localizer.forPackage(PreparedQueryCacheImpl.class);
        private static String STRONG = _loc.get("strong-exclusion").getMessage();
        private static String WEAK = _loc.get("weak-exclusion").getMessage();

        public ExclusionPattern(boolean strong, String pattern, String reason) {
            this._strong = strong;
            this._pattern = pattern;
            this._reason = reason;
        }

        public String getPattern() {
            return this._pattern;
        }

        public String getReason() {
            return this._reason;
        }

        public boolean isStrong() {
            return this._strong;
        }

        public boolean matches(String id) {
            return this._pattern != null && (this._pattern.equals(id) || this._pattern.matches(id));
        }

        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PreparedQueryCache.Exclusion)) {
                return false;
            }
            PreparedQueryCache.Exclusion that = (PreparedQueryCache.Exclusion)other;
            return this._strong == that.isStrong() && StringUtils.equals((String)this._pattern, (String)that.getPattern());
        }

        public int hashCode() {
            return (this._strong ? 1 : 0) + (this._pattern == null ? 0 : this._pattern.hashCode());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(" ").append(this._strong ? STRONG : WEAK).append(". ");
            if (this._reason != null) {
                buf.append(this._reason);
            }
            return buf.toString();
        }
    }
}

