/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.StoreException;

public class QueryException
extends StoreException {
    private static final transient Localizer _loc = Localizer.forPackage(QueryException.class);
    private int timeout = -1;

    public QueryException(Object failed) {
        super(_loc.get("query-failed"));
        this.setFailedObject(failed);
    }

    public QueryException(Object failed, int timeout) {
        super(_loc.get("query-timeout", String.valueOf(timeout)));
        this.setFailedObject(failed);
        this.setTimeout(timeout);
    }

    public int getSubtype() {
        return 6;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public QueryException setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public String toString() {
        String str = super.toString();
        if (this.timeout < 0) {
            return str;
        }
        return str + Exceptions.SEP + "Query Timeout: " + this.timeout;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.timeout);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.timeout = in.readInt();
    }
}

