/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class.getName());
    private static final Charset DEFAULT_ENCODING = Charset.forName("UTF-8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int post(URL url, String content, String contentType, int timeout) throws IOException {
        byte[] data = content.getBytes(DEFAULT_ENCODING);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestProperty("Content-Length", String.valueOf(data.length));
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setDoOutput(true);
            OutputStream output = connection.getOutputStream();
            output.write(data);
            output.flush();
            int responseCode = connection.getResponseCode();
            String error = HttpUtils.read(connection.getErrorStream());
            if (!HttpUtils.isValid(responseCode) || error != null) {
                throw new IOException("Posting to " + url + " returned HTTP code " + responseCode + " '" + connection.getResponseMessage() + "' with the following error: " + error);
            }
            int n = responseCode;
            return n;
        }
        finally {
            connection.disconnect();
        }
    }

    private static boolean isValid(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(InputStream stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Failed to read HTTP response error stream", e);
            }
        }
        finally {
            block15: {
                try {
                    br.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINEST)) break block15;
                    logger.log(Level.FINEST, "Failed to close HTTP response error stream", e);
                }
            }
        }
        return sb.toString();
    }
}

