/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;

public class UdpConnection {
    private final InetSocketAddress address;
    private final DatagramSocket socket;
    private final Charset charset;
    private boolean opened;

    public UdpConnection(String host, int port, Charset charset) throws SocketException {
        this.address = new InetSocketAddress(host, port);
        this.charset = charset;
        this.socket = new DatagramSocket();
        this.opened = true;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public synchronized void send(String content) throws IOException {
        if (this.opened) {
            byte[] data = content.getBytes(this.charset);
            this.socket.send(new DatagramPacket(data, data.length, this.address));
        }
    }

    public synchronized void close() {
        this.opened = false;
        this.socket.close();
    }
}

