/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb;

import com.gigaspaces.internal.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InfluxDBDispatcher
implements Closeable {
    private static final long THRESHOLD = 10L;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final AtomicLong failures = new AtomicLong();

    public void send(String data) {
        block5: {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Sending the following data: " + StringUtils.NEW_LINE + data);
            }
            try {
                this.doSend(data);
                long consecutive = this.failures.get();
                if (consecutive != 0L) {
                    this.logger.info("Report was sent successfully after " + consecutive + " consecutive failures");
                }
                this.failures.set(0L);
            }
            catch (IOException e) {
                long consecutive = this.failures.incrementAndGet();
                if (consecutive <= 10L && this.logger.isLoggable(Level.WARNING)) {
                    String message = consecutive < 10L ? "Failed to send report (" + consecutive + " consecutive failures)" + StringUtils.NEW_LINE + data : "Failed to send report (" + consecutive + " consecutive failures - additional failures will be logged as FINEST until the problem is resolved)" + StringUtils.NEW_LINE + data;
                    this.logger.log(Level.WARNING, message, e);
                }
                if (!this.logger.isLoggable(Level.FINEST)) break block5;
                this.logger.log(Level.FINEST, "Failed to send report ( + " + consecutive + " consecutive failures)" + StringUtils.NEW_LINE + data, e);
            }
        }
    }

    protected abstract void doSend(String var1) throws IOException;

    @Override
    public void close() {
    }
}

