/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.HttpUtils;
import com.gigaspaces.metrics.influxdb.InfluxDBDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfluxDBHttpDispatcher
extends InfluxDBDispatcher {
    private static final Logger logger = Logger.getLogger(InfluxDBHttpDispatcher.class.getName());
    private static final String CONTENT_TYPE = System.getProperty("com.gigaspaces.metrics.influxdb.http.content_type", "text/plain");
    private static final int TIMEOUT = Integer.getInteger("com.gigaspaces.metrics.influxdb.http.timeout", 30000);
    private final URL url;

    public InfluxDBHttpDispatcher(InfluxDBReporterFactory factory) {
        this.url = InfluxDBHttpDispatcher.toUrl(factory);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "InfluxDBHttpDispatcher created [url=" + this.url + "]");
        }
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    protected void doSend(String content) throws IOException {
        int httpCode = HttpUtils.post(this.url, content, CONTENT_TYPE, TIMEOUT);
        if (httpCode != 204) {
            throw new IOException("Failed to post [HTTP Code=" + httpCode + ", url=" + this.url.toString() + "]");
        }
    }

    private static URL toUrl(InfluxDBReporterFactory factory) {
        try {
            if (!StringUtils.hasLength((String)factory.getHost())) {
                throw new IllegalArgumentException("Mandatory property not provided - host");
            }
            if (!StringUtils.hasLength((String)factory.getDatabase())) {
                throw new IllegalArgumentException("Mandatory property not provided - database");
            }
            String suffix = "/write?db=" + factory.getDatabase();
            suffix = InfluxDBHttpDispatcher.append(suffix, "rp", factory.getRetentionPolicy());
            suffix = InfluxDBHttpDispatcher.append(suffix, "u", factory.getUsername());
            suffix = InfluxDBHttpDispatcher.append(suffix, "p", factory.getPassword());
            suffix = InfluxDBHttpDispatcher.append(suffix, "precision", InfluxDBHttpDispatcher.toString(factory.getTimePrecision()));
            suffix = InfluxDBHttpDispatcher.append(suffix, "consistency", factory.getConsistency());
            return new URL("http", factory.getHost(), factory.getPort(), suffix);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create InfluxDB HTTP url", e);
        }
    }

    private static String toString(TimeUnit timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        if (timeUnit == TimeUnit.NANOSECONDS) {
            return "n";
        }
        if (timeUnit == TimeUnit.MICROSECONDS) {
            return "u";
        }
        if (timeUnit == TimeUnit.MILLISECONDS) {
            return "ms";
        }
        if (timeUnit == TimeUnit.SECONDS) {
            return "s";
        }
        if (timeUnit == TimeUnit.MINUTES) {
            return "m";
        }
        if (timeUnit == TimeUnit.HOURS) {
            return "h";
        }
        throw new IllegalArgumentException("Unsupported time precision: " + (Object)((Object)timeUnit));
    }

    private static String append(String prefix, String name, String value) {
        return StringUtils.hasLength((String)value) ? prefix + '&' + name + '=' + value : prefix;
    }
}

