/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb;

import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.influxdb.InfluxDBDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBHttpDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory;
import com.gigaspaces.metrics.influxdb.InfluxDBUdpDispatcher;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfluxDBReporter
extends MetricReporter {
    private static final Logger logger = Logger.getLogger(InfluxDBReporter.class.getName());
    private static final String END_OF_METRIC = "\n";
    private static final NumberFormat numberFormat = InfluxDBReporter.createNumberFormat();
    private static final int MAX_FRACTION_DIGITS = Integer.getInteger("com.gs.metrics.influxdb.max-fraction-digits", 5);
    private final int maxReportLength;
    private final TimeUnit timePrecision;
    private final InfluxDBDispatcher dispatcher;
    private final StringBuilder buffer = new StringBuilder();

    private static NumberFormat createNumberFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(MAX_FRACTION_DIGITS);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public InfluxDBReporter(InfluxDBReporterFactory factory) {
        super((MetricReporterFactory)factory);
        this.maxReportLength = factory.getMaxReportLength();
        this.timePrecision = factory.getTimePrecision();
        this.dispatcher = this.createDispatcher(factory);
    }

    protected InfluxDBDispatcher createDispatcher(InfluxDBReporterFactory factory) {
        String protocol = factory.getProtocol();
        if (protocol.equalsIgnoreCase("http")) {
            return new InfluxDBHttpDispatcher(factory);
        }
        if (protocol.equalsIgnoreCase("udp")) {
            return new InfluxDBUdpDispatcher(factory);
        }
        throw new IllegalArgumentException("Unsupported InfluxDB Reporter protocol: " + protocol);
    }

    public void report(List<MetricRegistrySnapshot> snapshots) {
        super.report(snapshots);
        this.flush();
    }

    protected void report(MetricRegistrySnapshot snapshot, MetricTagsSnapshot tags, String key, Object value) {
        int beforeAppend = this.buffer.length();
        this.appendString(key);
        for (Map.Entry tag : tags.getTags().entrySet()) {
            this.buffer.append(',');
            this.appendString((String)tag.getKey());
            this.buffer.append('=');
            this.appendString(tag.getValue().toString());
        }
        this.buffer.append(" value=");
        this.appendValue(value);
        this.buffer.append(' ');
        this.buffer.append(this.convert(snapshot.getTimestamp()));
        this.buffer.append(END_OF_METRIC);
        if (this.buffer.length() > this.maxReportLength) {
            if (beforeAppend == 0) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Metrics report skipped because its length (" + this.buffer.length() + ") exceeds the maximum length (" + this.maxReportLength + ").\nReport: " + this.buffer.toString());
                }
                this.buffer.setLength(0);
            } else {
                this.buffer.setLength(beforeAppend);
                this.flush();
                this.report(snapshot, tags, key, value);
            }
        }
    }

    public void close() {
        this.dispatcher.close();
        super.close();
    }

    public InfluxDBDispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected long convert(long timestamp) {
        return this.timePrecision == TimeUnit.MILLISECONDS ? timestamp : this.timePrecision.convert(timestamp, TimeUnit.MILLISECONDS);
    }

    private void appendString(String s) {
        int SPACE = 32;
        int COMMA = 44;
        int EQUALS = 61;
        if (s.indexOf(32) == -1 && s.indexOf(44) == -1 && s.indexOf(61) == -1) {
            this.buffer.append(s);
        } else {
            int length = s.length();
            this.buffer.ensureCapacity(this.buffer.length() + length);
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || c == ',' || c == '=') {
                    this.buffer.append('\\');
                }
                this.buffer.append(c);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendValue(Object value) {
        if (value instanceof Number) {
            if (value instanceof Double) {
                this.buffer.append(numberFormat.format((Double)value));
                return;
            } else if (value instanceof Float) {
                this.buffer.append(numberFormat.format(((Float)value).floatValue()));
                return;
            } else {
                if (!(value instanceof Long) && !(value instanceof Integer) && !(value instanceof Short) && !(value instanceof Byte)) throw new IllegalArgumentException("Unsupported Number class - " + value.getClass().getName());
                this.buffer.append(value).append('i');
            }
            return;
        } else if (value instanceof String) {
            String s = (String)value;
            this.buffer.append('\"');
            if (s.indexOf(34) == -1) {
                this.buffer.append(value);
            } else {
                int length = s.length();
                this.buffer.ensureCapacity(this.buffer.length() + length);
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    if (c == '\"') {
                        this.buffer.append('\\');
                    }
                    this.buffer.append(c);
                }
            }
            this.buffer.append('\"');
            return;
        } else if (value instanceof Boolean) {
            this.buffer.append(value.equals(Boolean.TRUE) ? (char)'T' : 'F');
            return;
        } else {
            if (value != null) throw new IllegalArgumentException("Unsupported value class: " + value.getClass().getName());
            throw new IllegalArgumentException("InfluxDB does not support null values");
        }
    }

    private void flush() {
        if (this.buffer.length() != 0) {
            this.buffer.setLength(this.buffer.length() - END_OF_METRIC.length());
            this.dispatcher.send(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

