/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.influxdb.v_08.InfluxDBReporter;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class InfluxDBReporterFactory
extends MetricReporterFactory<MetricReporter> {
    public static final int DEFAULT_MAX_REPORT_LENGTH = 65507;
    public static final String DEFAULT_VERSION = "latest";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final int DEFAULT_PORT_HTTP = 8086;
    public static final int DEFAULT_PORT_UDP = 4444;
    private String version = "latest";
    private String protocol = "http";
    private int maxReportLength = 65507;
    private TimeUnit timePrecision = TimeUnit.NANOSECONDS;
    private String host;
    private int port;
    private String database;
    private String retentionPolicy;
    private String consistency;
    private String username;
    private String password;

    public void load(Properties properties) {
        super.load(properties);
        this.setVersion(properties.getProperty("version", DEFAULT_VERSION));
        this.setProtocol(properties.getProperty("protocol", DEFAULT_PROTOCOL));
        this.setMaxReportLength(InfluxDBReporterFactory.getIntProperty(properties, "max-report-length", 65507));
        if (this.protocol.equalsIgnoreCase(DEFAULT_PROTOCOL)) {
            this.setHost(properties.getProperty("host"));
            this.setPort(InfluxDBReporterFactory.getIntProperty(properties, "port", 8086));
            this.setDatabase(properties.getProperty("database"));
            this.setRetentionPolicy(properties.getProperty("retention-policy"));
            this.setUsername(properties.getProperty("username"));
            this.setPassword(properties.getProperty("password"));
            this.setTimePrecision(StringUtils.parseTimeUnit((String)properties.getProperty("precision"), (TimeUnit)TimeUnit.MILLISECONDS));
            this.setConsistency(properties.getProperty("consistency"));
        } else if (this.protocol.equalsIgnoreCase("udp")) {
            this.setHost(properties.getProperty("host"));
            this.setPort(InfluxDBReporterFactory.getIntProperty(properties, "port", 4444));
        }
    }

    private static int getIntProperty(Properties properties, String key, int defaultValue) {
        return properties.containsKey(key) ? Integer.parseInt(properties.getProperty(key)) : defaultValue;
    }

    public MetricReporter create() {
        if (this.version.equals("0.8")) {
            return new InfluxDBReporter(this);
        }
        if (this.version.equals("0.9") || this.version.equals(DEFAULT_VERSION)) {
            return new com.gigaspaces.metrics.influxdb.InfluxDBReporter(this);
        }
        throw new IllegalArgumentException("Unsupported version - " + this.version);
    }

    public int getMaxReportLength() {
        return this.maxReportLength;
    }

    public void setMaxReportLength(int maxReportLength) {
        this.maxReportLength = maxReportLength;
    }

    public TimeUnit getTimePrecision() {
        return this.timePrecision;
    }

    public void setTimePrecision(TimeUnit timePrecision) {
        this.timePrecision = timePrecision;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }
}

