/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb.v_08;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.HttpUtils;
import com.gigaspaces.metrics.influxdb.InfluxDBDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfluxDBHttpDispatcher
extends InfluxDBDispatcher {
    private static final Logger logger = Logger.getLogger(InfluxDBHttpDispatcher.class.getName());
    private static final String CONTENT_TYPE = System.getProperty("com.gigaspaces.metrics.influxdb.http.content_type", "application/json");
    private static final int TIMEOUT = Integer.getInteger("com.gigaspaces.metrics.influxdb.http.timeout", 30000);
    private final URL url;

    public InfluxDBHttpDispatcher(InfluxDBReporterFactory factory) {
        this.url = InfluxDBHttpDispatcher.toUrl(factory);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "InfluxDBHttpDispatcher created [url=" + this.url + "]");
        }
    }

    @Override
    protected void doSend(String content) throws IOException {
        int httpCode = HttpUtils.post(this.url, content, CONTENT_TYPE, TIMEOUT);
        if (httpCode != 200) {
            throw new IOException("Failed to post [HTTP Code=" + httpCode + ", url=" + this.url.toString() + "]");
        }
    }

    private static URL toUrl(InfluxDBReporterFactory factory) {
        try {
            String suffix = "";
            if (StringUtils.hasLength((String)factory.getUsername())) {
                suffix = InfluxDBHttpDispatcher.append(suffix, "u", URLEncoder.encode(factory.getUsername(), "utf-8"));
            }
            if (StringUtils.hasLength((String)factory.getPassword())) {
                suffix = InfluxDBHttpDispatcher.append(suffix, "p", factory.getPassword());
            }
            if (factory.getTimePrecision() != null) {
                suffix = InfluxDBHttpDispatcher.append(suffix, "time_precision", InfluxDBHttpDispatcher.toString(factory.getTimePrecision()));
            }
            suffix = "/db/" + factory.getDatabase() + "/series" + suffix;
            return new URL("http", factory.getHost(), factory.getPort(), suffix);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to create InfluxDB reporter", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create InfluxDB reporter", e);
        }
    }

    private static String toString(TimeUnit timeUnit) {
        if (timeUnit == TimeUnit.SECONDS) {
            return "s";
        }
        if (timeUnit == TimeUnit.MILLISECONDS) {
            return "ms";
        }
        if (timeUnit == TimeUnit.MICROSECONDS) {
            return "u";
        }
        throw new IllegalArgumentException("Unsupported time precision: " + (Object)((Object)timeUnit));
    }

    private static String append(String prefix, String name, String value) {
        return prefix + (prefix.length() == 0 ? (char)'?' : '&') + name + '=' + value;
    }
}

