/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb.v_08;

import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.influxdb.InfluxDBDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory;
import com.gigaspaces.metrics.influxdb.v_08.InfluxDBHttpDispatcher;
import com.gigaspaces.metrics.influxdb.v_08.InfluxDBUdpDispatcher;
import com.gigaspaces.metrics.influxdb.v_08.JSONStringBuilder;
import com.gigaspaces.metrics.influxdb.v_08.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfluxDBReporter
extends MetricReporter {
    private static final Logger logger = Logger.getLogger(InfluxDBReporter.class.getName());
    private static final String[] COLUMNS = new String[]{"time", "value"};
    private static final String SEPARATOR = ".";
    private static final String PREFIX_OS = "os.";
    private static final String PREFIX_OS_NETWORK = "os.network.";
    private static final String PREFIX_PROCESS = "process.";
    private static final String PREFIX_JVM = "jvm.";
    private static final String PREFIX_LRMI = "lrmi.";
    private static final String PREFIX_LUS = "lus.";
    private static final String PREFIX_PU = "pu.";
    private static final String PREFIX_SPACE = "space.";
    private final int maxReportLength;
    private final TimeUnit timePrecision;
    private final String xapSeparator;
    private final InfluxDBDispatcher dispatcher;
    private final JSONStringBuilder json = new JSONStringBuilder();
    private final Point singlePoint = new Point();
    private final List<Point> singlePointList = Collections.singletonList(this.singlePoint);
    private final Set<String> processedMetrics = new HashSet<String>();
    private final MultiPointList multiPointList = new MultiPointList();

    public InfluxDBReporter(InfluxDBReporterFactory factory) {
        super((MetricReporterFactory)factory);
        this.maxReportLength = factory.getMaxReportLength();
        this.timePrecision = factory.getTimePrecision();
        this.xapSeparator = factory.getPathSeparator();
        this.dispatcher = this.createDispatcher(factory);
    }

    protected InfluxDBDispatcher createDispatcher(InfluxDBReporterFactory factory) {
        String protocol = factory.getProtocol();
        if (protocol.equalsIgnoreCase("http")) {
            return new InfluxDBHttpDispatcher(factory);
        }
        if (protocol.equalsIgnoreCase("udp")) {
            return new InfluxDBUdpDispatcher(factory);
        }
        throw new IllegalArgumentException("Unsupported InfluxDB Reporter protocol: " + protocol);
    }

    public void close() {
        this.dispatcher.close();
        super.close();
    }

    public void report(List<MetricRegistrySnapshot> snapshots) {
        if (snapshots.size() == 1) {
            this.process(snapshots.get(0));
        } else {
            this.processedMetrics.clear();
            this.multiPointList.ensureCapacity(snapshots.size());
            this.process(snapshots, 0);
        }
        this.flush();
    }

    public int getMaxReportLength() {
        return this.maxReportLength;
    }

    protected long convert(long timestamp) {
        return this.timePrecision == null ? timestamp : this.timePrecision.convert(timestamp, TimeUnit.MILLISECONDS);
    }

    private void process(List<MetricRegistrySnapshot> snapshots, int startPos) {
        MetricRegistrySnapshot baseSnapshot = snapshots.get(startPos);
        for (Map.Entry groupEntry : baseSnapshot.getGroups().entrySet()) {
            MetricTagsSnapshot tags = (MetricTagsSnapshot)groupEntry.getKey();
            for (Map.Entry entry : ((MetricGroupSnapshot)groupEntry.getValue()).getMetricsValues().entrySet()) {
                String name = (String)entry.getKey();
                String fullName = this.getMetricNameForReport(name, tags);
                if (!this.processedMetrics.add(fullName)) continue;
                this.multiPointList.append(this.convert(baseSnapshot.getTimestamp()), entry.getValue());
                if (startPos != snapshots.size() - 1) {
                    for (int i = startPos + 1; i < snapshots.size(); ++i) {
                        MetricRegistrySnapshot currSnapshot = snapshots.get(i);
                        Map currGroup = ((MetricGroupSnapshot)currSnapshot.getGroups().get(tags)).getMetricsValues();
                        if (!currGroup.containsKey(name)) continue;
                        this.multiPointList.append(this.convert(currSnapshot.getTimestamp()), currGroup.get(name));
                    }
                }
                this.appendSeries(fullName, this.multiPointList.getList());
                this.multiPointList.clear();
            }
        }
        if (startPos + 1 < snapshots.size()) {
            this.process(snapshots, startPos + 1);
        }
    }

    private void process(MetricRegistrySnapshot snapshot) {
        for (Map.Entry groupEntry : snapshot.getGroups().entrySet()) {
            MetricTagsSnapshot tags = (MetricTagsSnapshot)groupEntry.getKey();
            for (Map.Entry entry : ((MetricGroupSnapshot)groupEntry.getValue()).getMetricsValues().entrySet()) {
                this.singlePoint.update(this.convert(snapshot.getTimestamp()), entry.getValue());
                this.appendSeries(this.getMetricNameForReport((String)entry.getKey(), tags), this.singlePointList);
            }
        }
    }

    private void appendSeries(String name, List<Point> points) {
        int beforeAppend = this.json.length();
        if (beforeAppend == 0) {
            this.json.append('[');
        }
        this.json.append('{');
        this.json.appendTupleString("name", name);
        this.json.appendTupleArray("columns", COLUMNS);
        this.json.appendTupleList("points", points);
        this.json.replaceLastChar('}');
        this.json.append(',');
        if (this.json.length() > this.getMaxReportLength()) {
            if (beforeAppend == 0) {
                this.finalizeReport();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Metrics report skipped because its length (" + this.json.length() + ") exceeds the maximum length (" + this.getMaxReportLength() + ").\nReport: " + this.json.toString());
                }
                this.json.reset();
            } else {
                this.json.setLength(beforeAppend);
                this.flush();
                this.appendSeries(name, points);
            }
        }
    }

    private void flush() {
        if (this.json.length() != 0) {
            this.finalizeReport();
            this.dispatcher.send(this.json.toString());
            this.json.reset();
        }
    }

    private void finalizeReport() {
        this.json.replaceLastChar(']');
    }

    protected String toReportMetricName(String metricName, MetricTagsSnapshot tags) {
        if ((metricName = this.replaceSeparatorIfNeeded(metricName)).startsWith(PREFIX_OS)) {
            return this.translateOSMetric(metricName, tags);
        }
        if (metricName.startsWith(PREFIX_PROCESS) || metricName.startsWith(PREFIX_JVM) || metricName.startsWith(PREFIX_LRMI)) {
            return this.translateProcessMetric(metricName, tags);
        }
        if (metricName.startsWith(PREFIX_LUS)) {
            return this.translateLusMetric(metricName, tags);
        }
        if (metricName.startsWith(PREFIX_PU)) {
            return this.translatePUMetric(metricName, tags);
        }
        if (metricName.startsWith(PREFIX_SPACE)) {
            return this.translateSpaceMetric(metricName, tags);
        }
        return super.toReportMetricName(metricName, tags);
    }

    private String translateOSMetric(String metricName, MetricTagsSnapshot tags) {
        String prefix = "xap." + this.getHost(tags) + SEPARATOR;
        if (metricName.startsWith(PREFIX_OS_NETWORK)) {
            prefix = prefix + PREFIX_OS_NETWORK + tags.getTags().get("nic") + SEPARATOR;
            metricName = metricName.substring(PREFIX_OS_NETWORK.length());
        }
        return prefix + metricName;
    }

    private String translateProcessMetric(String metricName, MetricTagsSnapshot tags) {
        String prefix = "xap.";
        prefix = tags.getTags().containsKey("pu_name") ? prefix + PREFIX_PU + this.getPuName(tags) + SEPARATOR + this.getPuInstanceId(tags) + SEPARATOR : prefix + this.getHost(tags) + SEPARATOR + this.getPid(tags) + SEPARATOR + tags.getTags().get("process_name") + SEPARATOR;
        return prefix + metricName;
    }

    private String translateLusMetric(String metricName, MetricTagsSnapshot tags) {
        return "xap." + this.getHost(tags) + SEPARATOR + this.getPid(tags) + SEPARATOR + metricName;
    }

    private String translatePUMetric(String metricName, MetricTagsSnapshot tags) {
        return "xap.pu." + this.getPuName(tags) + SEPARATOR + this.getPuInstanceId(tags) + SEPARATOR + metricName.substring(PREFIX_PU.length());
    }

    private String translateSpaceMetric(String metricName, MetricTagsSnapshot tags) {
        return "xap.pu." + this.getPuName(tags) + SEPARATOR + this.getPuInstanceId(tags) + SEPARATOR + PREFIX_SPACE + tags.getTags().get("space_name") + SEPARATOR + this.getSpaceInstanceId(tags) + SEPARATOR + (tags.getTags().get("space_active") == Boolean.TRUE ? "active." : "backup.") + metricName.substring(PREFIX_SPACE.length());
    }

    private Object getHost(MetricTagsSnapshot tags) {
        return tags.getTags().get("host");
    }

    private Object getPid(MetricTagsSnapshot tags) {
        return tags.getTags().get("pid");
    }

    private Object getPuName(MetricTagsSnapshot tags) {
        return tags.getTags().get("pu_name");
    }

    private Object getPuInstanceId(MetricTagsSnapshot tags) {
        return this.replaceSeparatorIfNeeded((String)tags.getTags().get("pu_instance_id"));
    }

    private Object getSpaceInstanceId(MetricTagsSnapshot tags) {
        return this.replaceSeparatorIfNeeded((String)tags.getTags().get("space_instance_id"));
    }

    private String replaceSeparatorIfNeeded(String s) {
        return this.xapSeparator.equals(SEPARATOR) ? s : s.replace(this.xapSeparator, SEPARATOR);
    }

    private class MultiPointList {
        private final ArrayList<Point> list = new ArrayList();
        private final ObjectPool<Point> pool;

        public MultiPointList() {
            this.pool = new ObjectPool<Point>(){

                @Override
                protected Point newInstance() {
                    return new Point();
                }
            };
        }

        public void append(long timestamp, Object value) {
            Point point = this.pool.acquire();
            point.update(timestamp, value);
            this.list.add(point);
        }

        public void ensureCapacity(int capacity) {
            this.list.ensureCapacity(capacity);
            this.pool.initialize(capacity);
        }

        public void clear() {
            for (Point point : this.list) {
                this.pool.release(point);
            }
            this.list.clear();
        }

        public List<Point> getList() {
            return this.list;
        }
    }

    public static class Point {
        public long timestamp;
        public Object value;

        public void update(long timestamp, Object value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

