/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb.v_08;

import com.gigaspaces.metrics.UdpConnection;
import com.gigaspaces.metrics.influxdb.InfluxDBDispatcher;
import com.gigaspaces.metrics.influxdb.InfluxDBReporterFactory;
import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfluxDBUdpDispatcher
extends InfluxDBDispatcher {
    private static final Logger logger = Logger.getLogger(InfluxDBUdpDispatcher.class.getName());
    private final UdpConnection connection;

    public InfluxDBUdpDispatcher(InfluxDBReporterFactory factory) {
        try {
            this.connection = new UdpConnection(factory.getHost(), factory.getPort(), Charset.forName("utf-8"));
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to create InfluxDBUdpDispatcher", e);
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "InfluxDBUdpDispatcher created [host=" + factory.getHost() + ", port=" + factory.getPort() + "]");
        }
    }

    @Override
    protected void doSend(String content) throws IOException {
        this.connection.send(content);
    }

    @Override
    public void close() {
        this.connection.close();
        super.close();
    }
}

