/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb.v_08;

import com.gigaspaces.metrics.influxdb.v_08.InfluxDBReporter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JSONStringBuilder {
    private final StringBuilder json = new StringBuilder();

    public String toString() {
        return this.json.toString();
    }

    public int length() {
        return this.json.length();
    }

    public void reset() {
        this.json.setLength(0);
    }

    public void appendTupleString(String key, String value) {
        this.appendString(key);
        this.appendTupleSeparator();
        this.appendString(value);
        this.json.append(',');
    }

    public void appendTupleArray(String key, Object[] value) {
        this.appendString(key);
        this.appendTupleSeparator();
        this.appendArray(value);
        this.json.append(',');
    }

    public void appendTupleList(String key, List value) {
        this.appendString(key);
        this.appendTupleSeparator();
        this.appendCollection(value);
        this.json.append(',');
    }

    public void appendValue(Object value) {
        if (value instanceof String) {
            this.appendString((String)value);
        } else if (value instanceof InfluxDBReporter.Point) {
            InfluxDBReporter.Point point = (InfluxDBReporter.Point)value;
            this.json.append('[');
            this.json.append(point.timestamp);
            this.json.append(',');
            this.appendValue(point.value);
            this.json.append(']');
        } else {
            this.json.append(value);
        }
    }

    public void appendString(String value) {
        this.json.append('\"').append(value).append('\"');
    }

    public void appendArray(Object[] array) {
        this.json.append('[');
        if (array.length != 0) {
            this.appendValue(array[0]);
            for (int i = 1; i < array.length; ++i) {
                this.json.append(',');
                this.appendValue(array[i]);
            }
        }
        this.json.append(']');
    }

    public void appendCollection(Collection collection) {
        this.json.append('[');
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            this.appendValue(iterator.next());
            while (iterator.hasNext()) {
                this.json.append(',');
                this.appendValue(iterator.next());
            }
        }
        this.json.append(']');
    }

    public void appendTupleSeparator() {
        this.json.append(':');
    }

    public void append(char c) {
        this.json.append(c);
    }

    public void setLength(int newLength) {
        this.json.setLength(newLength);
    }

    public void replaceLastChar(char c) {
        this.json.setCharAt(this.json.length() - 1, c);
    }
}

