/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.influxdb.v_08;

import java.lang.reflect.Array;

public abstract class ObjectPool<T> {
    private T[] pool;
    private int remaining;

    public ObjectPool<T> initialize(int capacity) {
        if (this.pool == null || this.pool.length != capacity) {
            this.pool = this.createPool(capacity);
            this.remaining = capacity;
        }
        return this;
    }

    public T acquire() {
        if (this.remaining > 0) {
            --this.remaining;
            T result = this.pool[this.remaining];
            this.pool[this.remaining] = null;
            return result;
        }
        return this.newInstance();
    }

    public void release(T instance) {
        if (this.remaining < this.pool.length) {
            this.pool[this.remaining++] = instance;
        }
    }

    protected T[] createPool(int capacity) {
        T instance = this.newInstance();
        Object[] pool = (Object[])Array.newInstance(instance.getClass(), capacity);
        pool[0] = instance;
        for (int i = 1; i < capacity; ++i) {
            pool[i] = this.newInstance();
        }
        return pool;
    }

    protected abstract T newInstance();
}

