/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class DataSourceUtils$ {
    public static final DataSourceUtils$ MODULE$;

    static {
        new DataSourceUtils$();
    }

    public void verifyWriteSchema(FileFormat format, StructType schema2) {
        this.verifySchema(format, schema2, false);
    }

    public void verifyReadSchema(FileFormat format, StructType schema2) {
        this.verifySchema(format, schema2, true);
    }

    private void verifySchema(FileFormat format, StructType schema2, boolean isReadPath) {
        schema2.foreach((Function1)new Serializable(format, isReadPath){
            public static final long serialVersionUID = 0L;
            private final FileFormat format$1;
            private final boolean isReadPath$1;

            public final void apply(StructField field) {
                if (this.format$1.supportDataType(field.dataType(), this.isReadPath$1)) {
                    return;
                }
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " data source does not support ", " data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format$1, field.dataType().catalogString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.format$1 = format$1;
                this.isReadPath$1 = isReadPath$1;
            }
        });
    }

    public boolean isDataPath(Path path) {
        String name2 = path.getName();
        return !name2.startsWith("_") && !name2.startsWith(".");
    }

    private DataSourceUtils$() {
        MODULE$ = this;
    }
}

