/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Traversable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u00164Vm\u0019;pe*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004WK\u000e$xN\u001d\u0005\t3\u0001\u0011)\u0019!C\u00015\u00051a/\u00197vKN,\u0012a\u0007\t\u0004\u001fqq\u0012BA\u000f\u0011\u0005\u0015\t%O]1z!\tyq$\u0003\u0002!!\t1Ai\\;cY\u0016D3\u0001\u0007\u0012)!\t\u0019c%D\u0001%\u0015\t)c!\u0001\u0006b]:|G/\u0019;j_:L!a\n\u0013\u0003\u000bMKgnY3\"\u0003%\nQ!\r\u00181]AB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaG\u0001\bm\u0006dW/Z:!Q\rQ#\u0005\u000b\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004CA\u000b\u0001\u0011\u0015IR\u00061\u0001\u001cQ\r\t$\u0005\u000b\u0015\u0004[\tB\u0003\"B\u001b\u0001\t\u00032\u0014\u0001B:ju\u0016,\u0012a\u000e\t\u0003\u001faJ!!\u000f\t\u0003\u0007%sG\u000fK\u00025E!BQ\u0001\u0010\u0001\u0005Bu\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002}A\u0011qH\u0011\b\u0003\u001f\u0001K!!\u0011\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003BAQA\u0012\u0001\u0005Bi\tq\u0001^8BeJ\f\u0017\u0010K\u0002FE!Ba!\u0013\u0001\u0005B\u0019Q\u0015\u0001C1t\u0005J,WM_3\u0016\u0003-\u00032\u0001\u0014)\u001f\u001b\u0005i%BA\u0002O\u0015\u0005y\u0015A\u00022sK\u0016TX-\u0003\u0002\u0018\u001b\")!\u000b\u0001C!'\u0006)\u0011\r\u001d9msR\u0011a\u0004\u0016\u0005\u0006+F\u0003\raN\u0001\u0002S\"\u001a\u0011K\t\u0015\t\u000ba\u0003A\u0011I-\u0002\t\r|\u0007/_\u000b\u0002a!\u001aqKI.\"\u0003q\u000bQ!\r\u00182]ABQA\u0018\u0001\u0005B}\u000bQBZ8sK\u0006\u001c\u0007.Q2uSZ,GC\u00011d!\ty\u0011-\u0003\u0002c!\t!QK\\5u\u0011\u0015!W\f1\u0001f\u0003\u00051\u0007#B\bgoy\u0001\u0017BA4\u0011\u0005%1UO\\2uS>t'\u0007K\u0002^E%\f\u0013A[\u0001\u0006c92d\u0006\r\u0005\u0006Y\u0002!\t%\\\u0001\u0007KF,\u0018\r\\:\u0015\u00059\f\bCA\bp\u0013\t\u0001\bCA\u0004C_>dW-\u00198\t\u000bI\\\u0007\u0019A:\u0002\u000b=$\b.\u001a:\u0011\u0005=!\u0018BA;\u0011\u0005\r\te.\u001f\u0005\u0006o\u0002!\t\u0005_\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0007C\u0003{\u0001\u0011\u0005c'\u0001\u0006ok6\f5\r^5wKND3!\u001f\u0012}C\u0005i\u0018!B\u0019/i9\u0002\u0004\"B@\u0001\t\u00032\u0014a\u00038v[:{gN_3s_ND3A \u0012}\u0011!\t)\u0001\u0001C!\u0005\u0005\u001d\u0011\u0001\u0005;p'B\f'o]3XSRD7+\u001b>f)\u0011\tI!a\u0004\u0011\u0007U\tY!C\u0002\u0002\u000e\t\u0011Ab\u00159beN,g+Z2u_JDq!!\u0005\u0002\u0004\u0001\u0007q'A\u0002o]jDa!!\u0006\u0001\t\u00032\u0014AB1sO6\f\u0007\u0010K\u0003\u0002\u0014\t\nI\"\t\u0002\u0002\u001c\u0005)\u0011GL\u001b/a!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0012A\u0002;p\u0015N|g.F\u0001?Q\u0011\tiBI5\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*\u0005!\u0011m]'M+\t\tY\u0003\u0005\u0003\u0002.\u0005URBAA\u0018\u0015\r\u0019\u0011\u0011\u0007\u0006\u0004\u0003g1\u0011AA7m\u0013\r\t\u0011q\u0006\u0015\u0006\u0003K\u0011\u0013\u0011H\u0011\u0003\u0003w\tQA\r\u00181]ABs\u0001AA \u0003\u001f\n\t\u0006\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u000bQL\b/Z:\u000b\u0007\u0005%c!A\u0002tc2LA!!\u0014\u0002D\t\u00112+\u0015'Vg\u0016\u0014H)\u001a4j]\u0016$G+\u001f9f\u0003\r)H\r^\u0012\u0003\u0003'\u00022!FA+\u0013\r\t9F\u0001\u0002\n-\u0016\u001cGo\u001c:V\tRC3\u0001\u0001\u0012)\u000f\u001d\tiF\u0001E\u0001\u0003?\n1\u0002R3og\u00164Vm\u0019;peB\u0019Q#!\u0019\u0007\r\u0005\u0011\u0001\u0012AA2'\u0015\t\tGDA3!\ry\u0011qM\u0005\u0004\u0003S\u0002\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u0018\u0002b\u0011\u0005\u0011Q\u000e\u000b\u0003\u0003?B\u0001\"!\u001d\u0002b\u0011\u0005\u00111O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)(a\u001f\u0011\t=\t9hG\u0005\u0004\u0003s\u0002\"AB(qi&|g\u000eC\u0004\u0002~\u0005=\u0004\u0019\u0001\u0019\u0002\u0005\u00114\b&BA8E\u0005\u0005\u0015EAAB\u0003\u0015\tdf\r\u00181\u0011!\t9)!\u0019\u0005\u0002\u0005%\u0015A\u00024s_6lE\nF\u00021\u0003\u0017C\u0001\"!$\u0002\u0006\u0002\u0007\u00111F\u0001\u0002m\"*\u0011Q\u0011\u0012\u0002:!Q\u00111SA1\u0003\u0003%I!!&\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003/\u0003B!!'\u0002$6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0003mC:<'BAAQ\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00161\u0014\u0002\u0007\u001f\nTWm\u0019;)\u000b\u0005\u0005$%!!)\u000b\u0005m#%!!")
public class DenseVector
implements Vector {
    private final double[] values;

    public static DenseVector fromML(org.apache.spark.ml.linalg.DenseVector denseVector) {
        return DenseVector$.MODULE$.fromML(denseVector);
    }

    public static Option<double[]> unapply(DenseVector denseVector) {
        return DenseVector$.MODULE$.unapply(denseVector);
    }

    @Override
    public SparseVector toSparse() {
        return Vector$class.toSparse(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values().length;
    }

    public String toString() {
        return Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]");
    }

    @Override
    public double[] toArray() {
        return this.values();
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new DenseVector.mcD.sp(this.values());
    }

    @Override
    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector((double[])this.values().clone());
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(i, localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int i = 0; i < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++i) {
            double v = this.values()[i];
            if (v == 0.0) continue;
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(this.values()[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.size();
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$2;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$2.elem;
                }
            }
            {
                this.nnz$2 = nnz$2;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        int[] ii = new int[nnz];
        double[] vv = new double[nnz];
        IntRef k = IntRef.create((int)0);
        this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
            public static final long serialVersionUID = 0L;
            private final int[] ii$1;
            private final double[] vv$1;
            private final IntRef k$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (v != 0.0) {
                    this.ii$1[this.k$1.elem] = i;
                    this.vv$1[this.k$1.elem] = v;
                    ++this.k$1.elem;
                }
            }
            {
                this.ii$1 = ii$1;
                this.vv$1 = vv$1;
                this.k$1 = k$1;
            }
        });
        return new SparseVector(this.size(), ii, vv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else {
            void var1_1;
            int maxIdx = 0;
            double maxValue = this.values()[0];
            for (int i = 1; i < this.size(); ++i) {
                if (!(this.values()[i] > maxValue)) continue;
                maxIdx = i;
                maxValue = this.values()[i];
            }
            n = var1_1;
        }
        return n;
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$6 = jValue = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)1)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)Predef$.MODULE$.doubleArrayOps(this.values()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(double x) {
                        return JsonDSL$.MODULE$.double2jvalue(x);
                    }
                });
            }
        });
        Formats x$7 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$6);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$6, x$7));
    }

    public org.apache.spark.ml.linalg.DenseVector asML() {
        return new org.apache.spark.ml.linalg.DenseVector(this.values());
    }

    public DenseVector(double[] values) {
        this.values = values;
        Vector$class.$init$(this);
    }
}

