/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowPopupMenuFactory;
import net.infonode.docking.action.CloseOthersWindowAction;
import net.infonode.docking.action.CloseWithAbortWindowAction;
import net.infonode.docking.action.DockWithAbortWindowAction;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.MinimizeWithAbortWindowAction;
import net.infonode.docking.action.RestoreWithAbortWindowAction;
import net.infonode.docking.action.UndockWithAbortWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewFactory;
import net.infonode.docking.util.ViewFactoryManager;
import net.infonode.gui.icon.button.ArrowIcon;
import net.infonode.gui.menu.MenuUtil;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.Direction;

public final class WindowMenuUtil {
    private static final Icon[] ARROW_ICONS = new Icon[4];

    private WindowMenuUtil() {
    }

    private static AbstractTabWindow getTabWindowFor(DockingWindow dockingWindow) {
        return (AbstractTabWindow)(dockingWindow instanceof AbstractTabWindow ? dockingWindow : (dockingWindow.getWindowParent() != null && dockingWindow.getWindowParent() instanceof AbstractTabWindow ? dockingWindow.getWindowParent() : null));
    }

    private static JMenu getMoveToMenuItems(final DockingWindow dockingWindow) {
        JMenu jMenu = new JMenu("Move to Window Bar");
        if (dockingWindow.isMinimizable()) {
            final RootWindow rootWindow = dockingWindow.getRootWindow();
            Direction[] directionArray = Direction.getDirections();
            for (int i = 0; i < 4; ++i) {
                final Direction direction = directionArray[i];
                if (DockingUtil.isAncestor(rootWindow.getWindowBar(direction), dockingWindow) || !rootWindow.getWindowBar(direction).isEnabled()) continue;
                jMenu.add(new JMenuItem(direction.getName(), ARROW_ICONS[i])).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        rootWindow.getWindowBar(direction).addTab(dockingWindow);
                    }
                });
            }
        }
        return jMenu;
    }

    private static void addWindowMenuItems(JPopupMenu jPopupMenu, DockingWindow dockingWindow) {
        JMenu jMenu;
        jPopupMenu.add(UndockWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        jPopupMenu.add(DockWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        jPopupMenu.add(RestoreWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        jPopupMenu.add(MinimizeWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        if (dockingWindow instanceof TabWindow) {
            jPopupMenu.add(MaximizeWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        }
        jPopupMenu.add(CloseWithAbortWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        if (dockingWindow.getWindowParent() instanceof AbstractTabWindow) {
            jPopupMenu.add(CloseOthersWindowAction.INSTANCE.getAction(dockingWindow).toSwingAction());
        }
        if ((jMenu = WindowMenuUtil.getMoveToMenuItems(dockingWindow)).getItemCount() > 0) {
            jPopupMenu.add(jMenu);
        }
    }

    private static void addNewViewMenuItems(JPopupMenu jPopupMenu, final DockingWindow dockingWindow, ViewFactoryManager viewFactoryManager) {
        ViewFactory[] viewFactoryArray = viewFactoryManager.getViewFactories();
        if (viewFactoryArray.length == 0) {
            return;
        }
        JMenu jMenu = new JMenu("Show View");
        for (int i = 0; i < viewFactoryArray.length; ++i) {
            final ViewFactory viewFactory = viewFactoryArray[i];
            jMenu.add(new JMenuItem(viewFactory.getTitle(), viewFactory.getIcon())).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    View view = viewFactory.createView();
                    if (view.getRootWindow() == dockingWindow.getRootWindow()) {
                        return;
                    }
                    view.restore();
                    if (view.getRootWindow() == dockingWindow.getRootWindow()) {
                        return;
                    }
                    if (dockingWindow instanceof RootWindow) {
                        ((RootWindow)dockingWindow).setWindow(view);
                    } else {
                        AbstractTabWindow abstractTabWindow = WindowMenuUtil.getTabWindowFor(dockingWindow);
                        if (abstractTabWindow != null) {
                            abstractTabWindow.addTab(view);
                        }
                    }
                }
            });
        }
        jPopupMenu.add(jMenu);
    }

    private static void addTabOrientationMenuItems(JPopupMenu jPopupMenu, DockingWindow dockingWindow) {
        final AbstractTabWindow abstractTabWindow = WindowMenuUtil.getTabWindowFor(dockingWindow);
        if (abstractTabWindow == null || abstractTabWindow instanceof WindowBar) {
            return;
        }
        JMenu jMenu = new JMenu("Tab Orientation");
        TabbedPanelProperties tabbedPanelProperties = abstractTabWindow.getTabWindowProperties().getTabbedPanelProperties();
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            final Direction direction = directionArray[i];
            JMenuItem jMenuItem = jMenu.add(new JMenuItem(direction.getName(), ARROW_ICONS[i]));
            jMenuItem.setEnabled(direction != tabbedPanelProperties.getTabAreaOrientation());
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    abstractTabWindow.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(direction);
                }
            });
        }
        jPopupMenu.add(jMenu);
    }

    private static void addTabDirectionMenuItems(JPopupMenu jPopupMenu, DockingWindow dockingWindow) {
        final AbstractTabWindow abstractTabWindow = WindowMenuUtil.getTabWindowFor(dockingWindow);
        if (abstractTabWindow == null) {
            return;
        }
        JMenu jMenu = new JMenu("Tab Direction");
        TitledTabProperties titledTabProperties = TitledTabProperties.getDefaultProperties();
        titledTabProperties.addSuperObject(abstractTabWindow.getTabWindowProperties().getTabProperties().getTitledTabProperties());
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            final Direction direction = directionArray[i];
            if (direction == Direction.LEFT) continue;
            JMenuItem jMenuItem = jMenu.add(new JMenuItem(direction.getName(), ARROW_ICONS[i]));
            jMenuItem.setEnabled(direction != titledTabProperties.getNormalProperties().getDirection());
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    abstractTabWindow.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setDirection(direction);
                }
            });
        }
        jPopupMenu.add(jMenu);
    }

    private static void addSplitWindowMenuItems(JPopupMenu jPopupMenu, final DockingWindow dockingWindow) {
        if (dockingWindow instanceof SplitWindow) {
            JMenu jMenu = new JMenu("Split Window");
            jMenu.add("25%").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((SplitWindow)dockingWindow).setDividerLocation(0.25f);
                }
            });
            jMenu.add("50%").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((SplitWindow)dockingWindow).setDividerLocation(0.5f);
                }
            });
            jMenu.add("75%").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((SplitWindow)dockingWindow).setDividerLocation(0.75f);
                }
            });
            jMenu.addSeparator();
            jMenu.add("Flip Orientation").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((SplitWindow)dockingWindow).setHorizontal(!((SplitWindow)dockingWindow).isHorizontal());
                }
            });
            jMenu.add("Mirror").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SplitWindow splitWindow = (SplitWindow)dockingWindow;
                    splitWindow.setWindows(dockingWindow.getChildWindow(1), dockingWindow.getChildWindow(0));
                    splitWindow.setDividerLocation(1.0f - splitWindow.getDividerLocation());
                }
            });
            jPopupMenu.add(jMenu);
        }
    }

    public static WindowPopupMenuFactory createWindowMenuFactory(ViewFactoryManager viewFactoryManager, boolean bl) {
        return WindowMenuUtil.createWindowMenuFactory(viewFactoryManager, bl, true);
    }

    public static WindowPopupMenuFactory createWindowMenuFactory(final ViewFactoryManager viewFactoryManager, final boolean bl, final boolean bl2) {
        return new WindowPopupMenuFactory(){

            public JPopupMenu createPopupMenu(DockingWindow dockingWindow) {
                JPopupMenu jPopupMenu = new JPopupMenu(dockingWindow.getTitle());
                if (!(dockingWindow instanceof RootWindow)) {
                    if (!(dockingWindow instanceof WindowBar)) {
                        WindowMenuUtil.addWindowMenuItems(jPopupMenu, dockingWindow);
                        jPopupMenu.addSeparator();
                    }
                    if (bl) {
                        WindowMenuUtil.addTabOrientationMenuItems(jPopupMenu, dockingWindow);
                        WindowMenuUtil.addTabDirectionMenuItems(jPopupMenu, dockingWindow);
                        jPopupMenu.addSeparator();
                    }
                    if (bl2) {
                        WindowMenuUtil.addSplitWindowMenuItems(jPopupMenu, dockingWindow);
                        jPopupMenu.addSeparator();
                    }
                }
                WindowMenuUtil.addNewViewMenuItems(jPopupMenu, dockingWindow, viewFactoryManager);
                MenuUtil.optimizeSeparators(jPopupMenu);
                MenuUtil.align(jPopupMenu);
                return jPopupMenu;
            }
        };
    }

    static {
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            WindowMenuUtil.ARROW_ICONS[i] = new ArrowIcon(11, directionArray[i]);
        }
    }
}

