/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s;

import com.gigaspaces.k8s.LightLogger;
import com.gigaspaces.k8s.MemoryParser;
import com.gigaspaces.rest.client.java.api.InformationApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.invoker.Configuration;
import com.gigaspaces.rest.client.java.model.EnvironmentInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class CommandInfo {
    private static final String KEY_VERBOSE = "verbose";
    private static final String KEY_POD_NAME = "podName";
    private static final String KEY_POD_ID = "podId";
    private static final String KEY_COMPONENT = "component";
    private static final String KEY_COMMAND = "command";
    private final Properties properties;
    private final LightLogger logger;

    public CommandInfo(String[] args) {
        this.properties = CommandInfo.toProperties(args);
        boolean verbose = Boolean.parseBoolean(this.properties.getProperty(KEY_VERBOSE, "false"));
        this.logger = new LightLogger(verbose);
        this.logger.verbose("Entry point properties: " + this.properties);
    }

    private static Properties toProperties(String[] args) {
        String name;
        int pos;
        Properties p = new Properties();
        for (String arg : args) {
            int pos2 = arg.indexOf(61);
            if (pos2 != -1) {
                p.setProperty(arg.substring(0, pos2), arg.substring(pos2 + 1));
                continue;
            }
            System.out.println("Warning: ignored invalid arg [" + arg + "]");
        }
        if (p.containsKey(KEY_POD_NAME) && !p.containsKey(KEY_POD_ID) && (pos = (name = p.getProperty(KEY_POD_NAME)).lastIndexOf(45)) != -1) {
            p.setProperty(KEY_POD_ID, name.substring(pos + 1));
        }
        return p;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public LightLogger getLogger() {
        return this.logger;
    }

    public String getPodId() {
        return this.properties.getProperty(KEY_POD_ID);
    }

    public String getOutputFile() {
        return this.properties.getProperty(KEY_COMMAND);
    }

    public String getComponent() {
        return this.properties.getProperty(KEY_COMPONENT);
    }

    public String getJavaHeap() {
        return new MemoryParser(this.logger).parseMemory(this.properties.getProperty("java.heap"));
    }

    public String getSpaceManagerName() {
        String spaceManager = this.properties.getProperty("manager.name");
        return spaceManager != null && !spaceManager.isEmpty() ? spaceManager : this.properties.getProperty("name");
    }

    public List<String> getManagerServers() throws ApiException {
        String port = this.properties.getProperty("manager.ports.api");
        String spaceManagerServiceName = this.getSpaceManagerName() + "-" + this.getProductName() + "-manager-service";
        String url = "http://" + spaceManagerServiceName + ":" + port + "/v2";
        InformationApi infApi = new InformationApi();
        infApi.setApiClient(Configuration.getDefaultApiClient().setBasePath(url));
        try {
            ApiResponse response = infApi.infoGetWithHttpInfo();
            LinkedList<String> result = response.getStatusCode() == 200 ? ((EnvironmentInfo)response.getData()).getManagers() : new LinkedList();
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to get manager servers from service pod " + spaceManagerServiceName, e);
            throw e;
        }
    }

    private String getProductName() {
        String chartName = this.properties.getProperty(KEY_POD_NAME);
        if (chartName.contains("xap")) {
            return "xap";
        }
        return "insightedge";
    }

    public CommandInfo appendOption(List<String> options, String key) {
        return this.appendOption(options, key, key);
    }

    public CommandInfo appendOption(List<String> options, String key, String property) {
        if (this.properties.containsKey(property)) {
            options.add("--" + key + "=" + this.properties.getProperty(property));
        }
        return this;
    }
}

