/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s;

import com.gigaspaces.k8s.CommandInfo;
import com.gigaspaces.k8s.CommandLineBuilder;
import com.gigaspaces.k8s.builders.InitSpaceCommandLineBuilder;
import com.gigaspaces.k8s.builders.ManagerCommandLineBuilder;
import com.gigaspaces.k8s.builders.ProcessingUnitInstanceCommandLineBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;

public class EntryPointCommandBuilder {
    public static void main(String[] args) {
        CommandInfo commandInfo = new CommandInfo(args);
        String command = EntryPointCommandBuilder.toCommandLineBuilder(commandInfo.getComponent()).toCommandLine(commandInfo);
        String outputFile = commandInfo.getOutputFile();
        try {
            Files.write(Paths.get(outputFile, new String[0]), Collections.singleton(command), new OpenOption[0]);
        }
        catch (IOException e) {
            commandInfo.getLogger().error("Failed to write output to " + outputFile, e);
        }
    }

    private static CommandLineBuilder toCommandLineBuilder(String builderType) {
        switch (builderType.toLowerCase()) {
            case "pu": {
                return new ProcessingUnitInstanceCommandLineBuilder();
            }
            case "manager": {
                return new ManagerCommandLineBuilder();
            }
            case "init": {
                return new InitSpaceCommandLineBuilder();
            }
        }
        throw new UnsupportedOperationException("Unsupported command line builder: [" + builderType + "]");
    }
}

