/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s;

import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.k8s.LightLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class MemoryParser {
    private final LightLogger logger;
    private final LimitProvider limitProvider;

    public MemoryParser(LightLogger logger) {
        this(logger, new CGroupLimitProvider());
    }

    public MemoryParser(LightLogger logger, LimitProvider limitProvider) {
        this.logger = logger;
        this.limitProvider = limitProvider;
    }

    public String parseMemory(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.endsWith("%")) {
            return this.parseMemoryPercentage(s, this.limitProvider);
        }
        if (s.contains("-")) {
            return this.parseMemoryDelta(s, this.limitProvider);
        }
        return s;
    }

    private String parseMemoryPercentage(String s, LimitProvider limitProvider) {
        long limit;
        try {
            limit = limitProvider.loadLimit();
        }
        catch (IOException e) {
            this.logger.error("Failed to read memory limit", e);
            return null;
        }
        double factor = Double.parseDouble(s.replace("%", "")) / 100.0;
        String result = String.valueOf(Math.round((double)limit * factor));
        this.logger.verbose("Java Memory: resources.limits.memory=[" + limit + "], java.memory=[" + s + "], result=[" + result + "]");
        return result;
    }

    private String parseMemoryDelta(String s, LimitProvider limitProvider) {
        long limit;
        try {
            limit = limitProvider.loadLimit();
        }
        catch (IOException e) {
            this.logger.error("Failed to read memory limit", e);
            return null;
        }
        s = s.replace(" ", "");
        String prefix = "limit-";
        if (!s.startsWith(prefix)) {
            this.logger.error("Unsupported syntax: '" + s + "'");
            return null;
        }
        long delta = BootIOUtils.parseStringAsBytes((String)s.substring(prefix.length()));
        String result = String.valueOf(limit - delta);
        this.logger.verbose("Java Memory: resources.limits.memory=[" + limit + "], java.memory=[" + s + "], result=[" + result + "]");
        return result;
    }

    private static Properties readCGroupStats(String category) throws IOException {
        Properties result = new Properties();
        Path path = Paths.get("/sys/fs/cgroup", category, category + ".stat");
        Files.lines(path).forEach(line -> {
            String[] tokens = line.split(" ");
            result.setProperty(tokens[0], tokens[1]);
        });
        return result;
    }

    private static class CGroupLimitProvider
    implements LimitProvider {
        private CGroupLimitProvider() {
        }

        @Override
        public long loadLimit() throws IOException {
            return Long.parseLong(MemoryParser.readCGroupStats("memory").getProperty("hierarchical_memory_limit"));
        }
    }

    public static interface LimitProvider {
        public long loadLimit() throws IOException;
    }
}

