/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s.builders;

import com.gigaspaces.k8s.CommandInfo;
import com.gigaspaces.k8s.CommandLineBuilder;
import com.gigaspaces.k8s.LightLogger;
import java.util.concurrent.TimeUnit;

public class InitSpaceCommandLineBuilder
extends CommandLineBuilder {
    @Override
    public String toCommandLine(CommandInfo commandInfo) {
        commandInfo.getLogger().info("Performing Init container");
        if (this.waitUntilManagerDeployed(commandInfo)) {
            commandInfo.getLogger().info("Manager is Deployed - Space container will begin to deploy soon");
            return "exit 0";
        }
        commandInfo.getLogger().error("Init Container encountered timeout, will stop waiting for manager " + commandInfo.getSpaceManagerName() + " to connect");
        return "exit 1";
    }

    private boolean waitUntilManagerDeployed(CommandInfo commandInfo) {
        LightLogger logger = commandInfo.getLogger();
        int checkManagerIntervalSeconds = Integer.parseInt(commandInfo.getProperty("manager.discoveryTimeoutSeconds"));
        int numOfIterations = Math.round(checkManagerIntervalSeconds / 3);
        int countIterations = 0;
        boolean isManagerDeployed = false;
        String spaceManagerName = commandInfo.getSpaceManagerName();
        logger.info("Init container beginning to wait until manager is deployed");
        while (!isManagerDeployed) {
            try {
                logger.info("Wait Until Manager Deployed- in the loop - " + countIterations);
                if (++countIterations >= numOfIterations) {
                    logger.error(InitSpaceCommandLineBuilder.getDebugErrorMsg(checkManagerIntervalSeconds, spaceManagerName));
                    return false;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
                isManagerDeployed = !commandInfo.getManagerServers().isEmpty();
            }
            catch (Exception e) {
                if (countIterations < numOfIterations) continue;
                logger.error(InitSpaceCommandLineBuilder.getDebugErrorMsg(checkManagerIntervalSeconds, spaceManagerName));
                e.printStackTrace();
            }
        }
        return true;
    }

    private static String getDebugErrorMsg(int checkManagerIntervalSeconds, String spaceManagerName) {
        return "Init Container failed to connect to manager " + spaceManagerName + " for " + checkManagerIntervalSeconds + " seconds, Please try again in a few minutes or try to connect to a different manager.";
    }
}

