/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s.builders;

import com.gigaspaces.cli.GsPremiumCommandFactory;
import com.gigaspaces.k8s.CommandInfo;
import com.gigaspaces.k8s.CommandLineBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.IntStream;

public class ManagerCommandLineBuilder
extends CommandLineBuilder {
    @Override
    public String toCommandLine(CommandInfo commandInfo) {
        int podId = Integer.parseInt(commandInfo.getPodId());
        String command = GsPremiumCommandFactory.serviceGrid(this.toComponentOptions(commandInfo));
        return String.join((CharSequence)System.lineSeparator(), "export XAP_MANAGER_SERVERS=" + ManagerCommandLineBuilder.toManagerServers(commandInfo), "export XAP_PUBLIC_HOST=\"" + ManagerCommandLineBuilder.toManagerPublicHostName(commandInfo, podId) + "\"", "export XAP_LICENSE=\"N/A\"", "exec " + command + " services=LH,ZK,REST");
    }

    private Collection<String> toComponentOptions(CommandInfo commandInfo) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Dcom.gs.admin.discover-un-managed-spaces=true");
        String memory = commandInfo.getJavaHeap();
        if (memory != null && !memory.isEmpty()) {
            options.add("-Xmx" + memory);
        }
        return options;
    }

    private static String toManagerServers(CommandInfo commandInfo) {
        int replicasNum = Integer.parseInt(commandInfo.getProperty("managerReplicas"));
        ArrayList strList = new ArrayList();
        IntStream.range(0, replicasNum).forEach(i -> strList.add(ManagerCommandLineBuilder.toManagerPublicHostName(commandInfo, i)));
        return '\"' + String.join((CharSequence)",", strList) + '\"';
    }

    private static String toManagerPublicHostName(CommandInfo commandInfo, int managerId) {
        String managerFullName = commandInfo.getProperty("full.name");
        return managerFullName + "-" + managerId + "." + managerFullName + "-hs." + commandInfo.getProperty("release.namespace") + ".svc.cluster.local";
    }
}

