/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.k8s.builders;

import com.gigaspaces.cli.GsPremiumCommandFactory;
import com.gigaspaces.k8s.CommandInfo;
import com.gigaspaces.k8s.CommandLineBuilder;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class ProcessingUnitInstanceCommandLineBuilder
extends CommandLineBuilder {
    @Override
    public String toCommandLine(CommandInfo commandInfo) {
        LinkedList<String> commands = new LinkedList<String>();
        String license = commandInfo.getProperty("license");
        if (license != null && !license.isEmpty()) {
            commands.add("export XAP_LICENSE=\"" + license + '\"');
        }
        commands.add("export XAP_MANAGER_SERVERS=" + this.getManagerServers(commandInfo));
        String command = GsPremiumCommandFactory.serviceGrid(this.toComponentOptions(commandInfo));
        commands.add("exec " + command + " services=GSC " + this.toArgs(commandInfo));
        return String.join((CharSequence)System.lineSeparator(), commands);
    }

    private String toArgs(CommandInfo commandInfo) {
        ArrayList<String> options = new ArrayList<String>();
        commandInfo.appendOption(options, "name");
        commandInfo.appendOption(options, "schema");
        commandInfo.appendOption(options, "instances");
        options.add("--instanceId=" + (Integer.valueOf(commandInfo.getPodId()) + 1));
        if (commandInfo.getProperties().containsKey("partitions")) {
            commandInfo.appendOption(options, "partitions");
            commandInfo.appendOption(options, "partitionId");
        }
        if (commandInfo.getProperties().containsKey("ha")) {
            commandInfo.appendOption(options, "ha");
            options.add("--backupId=" + commandInfo.getPodId());
        }
        commandInfo.appendOption(options, "pu.resourceUrl");
        if (commandInfo.getProperties().containsKey("pu.properties")) {
            options.add("--pu.properties=" + this.getPuProperties(commandInfo.getProperty("pu.properties")));
        }
        return String.join((CharSequence)" ", options);
    }

    private String getPuProperties(String puProperties) {
        if (puProperties == null || puProperties.isEmpty()) {
            return "";
        }
        if (puProperties.startsWith("embed://")) {
            return puProperties;
        }
        return "embed://" + puProperties;
    }

    private Collection<String> toComponentOptions(CommandInfo commandInfo) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Dcom.gs.space.rest.enabled=true");
        String memory = commandInfo.getJavaHeap();
        if (memory != null && !memory.isEmpty()) {
            options.add("-Xms" + memory);
            options.add("-Xmx" + memory);
        }
        return options;
    }

    private String getManagerServers(CommandInfo commandInfo) {
        String result;
        try {
            result = '\"' + String.join((CharSequence)",", commandInfo.getManagerServers()) + '\"';
        }
        catch (ApiException e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }
}

