/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.blueprints;

import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.logger.LoggerSystemInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.gigaspaces.blueprints.TemplateUtils;

public class Blueprint {
    private static final String TEMPLATES_PATH = "templates";
    private static final String INFO_PATH = "blueprint.txt";
    private static final String VALUES_PATH = "values.txt";
    private static final Map<String, Object> defaultContext = Blueprint.initDefaultContext();
    private final String name;
    private final Path content;
    private final Path valuesPath;
    private final Map<String, String> properties;

    public Blueprint(Path home) {
        this.name = home.getFileName().toString();
        this.content = home.resolve(TEMPLATES_PATH);
        this.valuesPath = home.resolve(VALUES_PATH);
        try {
            this.properties = Blueprint.load(home.resolve(INFO_PATH));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load blueprint information", e);
        }
    }

    public static boolean isValid(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.exists(path.resolve(TEMPLATES_PATH), new LinkOption[0]) && Files.exists(path.resolve(INFO_PATH), new LinkOption[0]) && Files.exists(path.resolve(VALUES_PATH), new LinkOption[0]);
    }

    public static Collection<Blueprint> fromPath(Path path) throws IOException {
        return Files.list(path).filter(Blueprint::isValid).map(Blueprint::new).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getInfo("description");
    }

    public String getInfo(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getValues() throws IOException {
        return Blueprint.load(this.valuesPath);
    }

    public void generate(Path target) throws IOException {
        this.generate(target, Collections.emptyMap());
    }

    public void generate(Path target, Map<String, Object> userOverrides) throws IOException {
        if (Files.exists(target, new LinkOption[0])) {
            throw new IllegalArgumentException("Target already exists: " + target);
        }
        Map<String, Object> context = this.loadContext(userOverrides);
        TemplateUtils.evaluateTree(this.content, target, context);
    }

    private Map<String, Object> loadContext(Map<String, Object> userOverrides) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(defaultContext);
        result.putAll(this.getValues());
        if (userOverrides != null) {
            result.putAll(userOverrides);
        }
        return this.expand(result);
    }

    private Map<String, Object> expand(Map<String, Object> context) {
        boolean replaced = false;
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            Optional<Object> newValue = Blueprint.expand(entry.getValue(), context);
            if (!newValue.isPresent()) continue;
            entry.setValue(newValue.get());
            replaced = true;
        }
        return context;
    }

    private static Optional<Object> expand(Object value, Map<String, Object> context) {
        if (!(value instanceof String)) {
            return Optional.empty();
        }
        String s = (String)value;
        if (!s.contains("{{")) {
            return Optional.empty();
        }
        return Optional.of(TemplateUtils.evaluate(s, context));
    }

    private static Map<String, Object> initDefaultContext() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("gs.path", s -> s.replace('.', File.separatorChar));
        result.put("gs.version", PlatformVersion.getInstance().getId());
        result.put("gs.home", LoggerSystemInfo.xapHome);
        return result;
    }

    private static Map<String, String> load(Path path) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileInputStream stream = new FileInputStream(path.toString());){
            Properties p = new Properties();
            p.load(stream);
            p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v.toString())));
        }
        return result;
    }
}

