/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.blueprints;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.gigaspaces.blueprints.Blueprint;

public class BlueprintRepository {
    private final Map<String, Blueprint> blueprints;

    public BlueprintRepository(Path home) throws IOException {
        Objects.requireNonNull(home);
        if (!Files.exists(home, new LinkOption[0])) {
            throw new IllegalArgumentException("Template manager home does not exist: " + home);
        }
        this.blueprints = new LinkedHashMap<String, Blueprint>();
        for (Blueprint blueprint : Blueprint.fromPath(home)) {
            this.blueprints.put(blueprint.getName(), blueprint);
        }
    }

    public Set<String> getNames() {
        return this.blueprints.keySet();
    }

    public Collection<Blueprint> getBlueprints() {
        return this.blueprints.values();
    }

    public Blueprint get(String name) {
        return this.blueprints.get(name);
    }

    public Blueprint get(int index) {
        for (Blueprint blueprint : this.blueprints.values()) {
            if (index-- != 0) continue;
            return blueprint;
        }
        throw new IllegalStateException();
    }

    public Optional<Integer> indexOf(String name) {
        int index = 0;
        for (Map.Entry<String, Blueprint> entry : this.blueprints.entrySet()) {
            if (entry.getKey().equals(name)) {
                return Optional.of(index);
            }
            ++index;
        }
        return Optional.empty();
    }
}

