/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.blueprints;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;

public class TemplateUtils {
    private static final MustacheFactory mf = new DefaultMustacheFactory();
    private static final String IOEXCEPTION_WRAPPER = "IOException wrapper";

    public static String evaluate(String text, Map<String, Object> context) {
        Mustache m = mf.compile((Reader)new StringReader(text), "temp.name");
        return m.execute((Writer)new StringWriter(), context).toString();
    }

    public static void evaluate(Path src, Path dst, Map<String, Object> context) throws IOException {
        if (Files.isDirectory(src, new LinkOption[0])) {
            Files.createDirectories(dst, new FileAttribute[0]);
        } else {
            try (FileReader reader = new FileReader(src.toFile());
                 FileWriter writer = new FileWriter(dst.toFile());){
                mf.compile((Reader)reader, "temp.name").execute((Writer)writer, context);
            }
        }
    }

    public static void evaluateTree(Path src, Path dst, Map<String, Object> context) throws IOException {
        try (Stream<Path> tree = Files.walk(src, new FileVisitOption[0]);){
            tree.forEach(p -> {
                try {
                    Path target = TemplateUtils.evaluatePath(dst.resolve(src.relativize((Path)p)), context);
                    TemplateUtils.evaluate(p, target, context);
                }
                catch (IOException e) {
                    throw new RuntimeException(IOEXCEPTION_WRAPPER, e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals(IOEXCEPTION_WRAPPER)) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private static Path evaluatePath(Path path, Map<String, Object> properties) {
        String s = path.toString();
        return s.contains("{{") ? Paths.get(TemplateUtils.evaluate(s, properties), new String[0]) : path;
    }
}

