/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.python.proto.CancelRequest;
import org.apache.zeppelin.python.proto.CancelResponse;
import org.apache.zeppelin.python.proto.CompletionRequest;
import org.apache.zeppelin.python.proto.CompletionResponse;
import org.apache.zeppelin.python.proto.ExecuteRequest;
import org.apache.zeppelin.python.proto.ExecuteResponse;
import org.apache.zeppelin.python.proto.ExecuteStatus;
import org.apache.zeppelin.python.proto.IPythonGrpc;
import org.apache.zeppelin.python.proto.OutputType;
import org.apache.zeppelin.python.proto.StatusRequest;
import org.apache.zeppelin.python.proto.StatusResponse;
import org.apache.zeppelin.python.proto.StopRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPythonClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)IPythonClient.class.getName());
    private final ManagedChannel channel;
    private final IPythonGrpc.IPythonBlockingStub blockingStub;
    private final IPythonGrpc.IPythonStub asyncStub;
    private SecureRandom random = new SecureRandom();

    public IPythonClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext(true));
    }

    public IPythonClient(ManagedChannelBuilder<?> channelBuilder) {
        this.channel = channelBuilder.build();
        this.blockingStub = IPythonGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = IPythonGrpc.newStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResponse stream_execute(ExecuteRequest request, final InterpreterOutputStream interpreterOutput) {
        final ExecuteResponse.Builder finalResponseBuilder = ExecuteResponse.newBuilder().setStatus(ExecuteStatus.SUCCESS);
        final AtomicBoolean completedFlag = new AtomicBoolean(false);
        LOGGER.debug("stream_execute code:\n" + request.getCode());
        this.asyncStub.execute(request, new StreamObserver<ExecuteResponse>(){
            int index = 0;
            boolean isPreviousOutputImage = false;

            public void onNext(ExecuteResponse executeResponse) {
                if (executeResponse.getType() == OutputType.TEXT) {
                    try {
                        LOGGER.debug("Interpreter Streaming Output: " + executeResponse.getOutput());
                        if (this.isPreviousOutputImage) {
                            interpreterOutput.write("\n%text ".getBytes());
                        }
                        this.isPreviousOutputImage = false;
                        interpreterOutput.write(executeResponse.getOutput().getBytes());
                        interpreterOutput.getInterpreterOutput().flush();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unexpected IOException", (Throwable)e);
                    }
                }
                if (executeResponse.getType() == OutputType.IMAGE) {
                    try {
                        LOGGER.debug("Interpreter Streaming Output: IMAGE_DATA");
                        if (this.index != 0) {
                            interpreterOutput.write("\n".getBytes());
                        }
                        interpreterOutput.write(("%img " + executeResponse.getOutput()).getBytes());
                        interpreterOutput.getInterpreterOutput().flush();
                        this.isPreviousOutputImage = true;
                    }
                    catch (IOException e) {
                        LOGGER.error("Unexpected IOException", (Throwable)e);
                    }
                }
                if (executeResponse.getStatus() == ExecuteStatus.ERROR) {
                    finalResponseBuilder.setStatus(ExecuteStatus.ERROR);
                }
                ++this.index;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable throwable) {
                try {
                    interpreterOutput.getInterpreterOutput().write(ExceptionUtils.getStackTrace((Throwable)throwable));
                    interpreterOutput.getInterpreterOutput().flush();
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected IOException", (Throwable)e);
                }
                LOGGER.error("Fail to call IPython grpc", throwable);
                finalResponseBuilder.setStatus(ExecuteStatus.ERROR);
                completedFlag.set(true);
                AtomicBoolean atomicBoolean = completedFlag;
                synchronized (atomicBoolean) {
                    completedFlag.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                AtomicBoolean atomicBoolean = completedFlag;
                synchronized (atomicBoolean) {
                    try {
                        LOGGER.debug("stream_execute is completed");
                        interpreterOutput.getInterpreterOutput().flush();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unexpected IOException", (Throwable)e);
                    }
                    completedFlag.set(true);
                    completedFlag.notify();
                }
            }
        });
        AtomicBoolean atomicBoolean = completedFlag;
        synchronized (atomicBoolean) {
            if (!completedFlag.get()) {
                try {
                    completedFlag.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Unexpected Interruption", (Throwable)e);
                }
            }
        }
        return finalResponseBuilder.build();
    }

    public ExecuteResponse block_execute(ExecuteRequest request) {
        ExecuteResponse.Builder responseBuilder = ExecuteResponse.newBuilder();
        responseBuilder.setStatus(ExecuteStatus.SUCCESS);
        Iterator<ExecuteResponse> iter = this.blockingStub.execute(request);
        StringBuilder outputBuilder = new StringBuilder();
        while (iter.hasNext()) {
            ExecuteResponse nextResponse = iter.next();
            if (nextResponse.getStatus() == ExecuteStatus.ERROR) {
                responseBuilder.setStatus(ExecuteStatus.ERROR);
            }
            outputBuilder.append(nextResponse.getOutput());
        }
        responseBuilder.setOutput(outputBuilder.toString());
        return responseBuilder.build();
    }

    public CancelResponse cancel(CancelRequest request) {
        return this.blockingStub.cancel(request);
    }

    public CompletionResponse complete(CompletionRequest request) {
        return this.blockingStub.complete(request);
    }

    public StatusResponse status(StatusRequest request) {
        return this.blockingStub.status(request);
    }

    public void stop(StopRequest request) {
        this.asyncStub.stop(request, null);
    }

    public static void main(String[] args) {
        IPythonClient client = new IPythonClient("localhost", 50053);
        client.status(StatusRequest.newBuilder().build());
        ExecuteResponse response = client.block_execute(ExecuteRequest.newBuilder().setCode("abcd=2").build());
        System.out.println(response.getOutput());
    }
}

