/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonInterpreterPandasSql
extends Interpreter {
    private static final Logger LOG = LoggerFactory.getLogger(PythonInterpreterPandasSql.class);
    private String SQL_BOOTSTRAP_FILE_PY = "/python/bootstrap_sql.py";

    public PythonInterpreterPandasSql(Properties property) {
        super(property);
    }

    PythonInterpreter getPythonInterpreter() throws InterpreterException {
        LazyOpenInterpreter lazy = null;
        PythonInterpreter python = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(PythonInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)p).getInnerInterpreter();
        }
        python = (PythonInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return python;
    }

    public void open() throws InterpreterException {
        LOG.info("Open Python SQL interpreter instance: {}", (Object)((Object)((Object)this)).toString());
        try {
            LOG.info("Bootstrap {} interpreter with {}", (Object)((Object)((Object)this)).toString(), (Object)this.SQL_BOOTSTRAP_FILE_PY);
            PythonInterpreter python = this.getPythonInterpreter();
            python.bootStrapInterpreter(this.SQL_BOOTSTRAP_FILE_PY);
        }
        catch (IOException e) {
            LOG.error("Can't execute " + this.SQL_BOOTSTRAP_FILE_PY + " to import SQL dependencies", (Throwable)e);
        }
    }

    public void close() throws InterpreterException {
        LOG.info("Close Python SQL interpreter instance: {}", (Object)((Object)((Object)this)).toString());
        PythonInterpreter python = this.getPythonInterpreter();
        python.close();
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        LOG.info("Running SQL query: '{}' over Pandas DataFrame", (Object)st);
        PythonInterpreter python = this.getPythonInterpreter();
        return python.interpret("__zeppelin__.show(pysqldf('" + st + "'))", context);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }
}

