/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli;

import com.gigaspaces.logger.GSLogConfigLoader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gigaspaces.cli.commands.XapVersionProvider;
import org.jini.rio.boot.BootUtil;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=XapVersionProvider.class, sortOptions=false, synopsisHeading="Usage: ", descriptionHeading="%nDescription: ", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n")
public abstract class CliCommand
implements Callable<Object> {
    protected static Logger LOGGER;
    @CommandLine.Option(names={"--help"}, usageHelp=true, description={"Show the help information for this command"})
    boolean usageHelpRequested;

    @Override
    public Object call() throws Exception {
        this.beforeExecute();
        try {
            this.execute();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                String stackTrace = BootUtil.getStackTrace((Throwable)e);
                LOGGER.log(Level.FINEST, "Execution of [" + this.getClass() + "] threw an exception.\nStack trace: " + stackTrace, e);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Execution of [" + this.getClass() + "] threw an exception.", e);
            }
            throw e;
        }
        return null;
    }

    public CliCommand() {
        GSLogConfigLoader.getLoader((String)"cli");
        LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    }

    protected void beforeExecute() {
    }

    protected abstract void execute() throws Exception;

    protected void underConstruction() {
        CommandLine.Command command = this.getClass().getAnnotation(CommandLine.Command.class);
        System.out.println("Command " + command.name() + " is under construction");
    }
}

