/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.fusesource.jansi.AnsiConsole;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.SubCommandContainer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.TerminalBuilder;
import picocli.AutoComplete;
import picocli.CommandLine;

public class CliExecutor {
    private static CommandLine mainCommandLine;
    private static LineReader shellReader;

    public static CommandLine getMainCommand() {
        return mainCommandLine;
    }

    public static void execute(Object mainCommand, String[] args) {
        int exitCode;
        try {
            AnsiConsole.systemInstall();
            mainCommandLine = CliExecutor.toCommandLine(mainCommand);
            CliExecutor.execute(mainCommandLine, args);
            exitCode = 0;
        }
        catch (Exception e) {
            exitCode = CliExecutor.handleException(e);
        }
        System.exit(exitCode);
    }

    private static void execute(CommandLine mainCommandLine, String[] args) {
        mainCommandLine.parseWithHandlers((CommandLine.IParseResultHandler2)new CustomRunner(), (CommandLine.IExceptionHandler2)new CommandLine.DefaultExceptionHandler(), args);
    }

    public static void generateAutoComplete(Object mainCommand, String[] args) throws IOException {
        CommandLine commandLine = CliExecutor.toCommandLine(mainCommand);
        String alias = args.length != 0 ? args[0] : commandLine.getCommandName();
        String generatedScript = AutoComplete.bash((String)alias, (CommandLine)commandLine);
        try (FileWriter scriptWriter = new FileWriter(new File(alias + "-autocomplete"));){
            scriptWriter.write(generatedScript);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void executeShell(CommandLine mainCommandLine) {
        System.out.println("Starting interactive shell...");
        mainCommandLine.addSubcommand("cls", (Object)ShellClearCommand.access$100());
        mainCommandLine.addSubcommand("exit", (Object)ShellExitCommand.access$200());
        try {
            CliExecutor.shellReader = LineReaderBuilder.builder().terminal(TerminalBuilder.builder().build()).completer((Completer)new PicocliJLineCompleter(mainCommandLine.getCommandSpec())).parser((Parser)new DefaultParser()).build();
            ShellClearCommand.access$302(ShellClearCommand.access$100(), (LineReaderImpl)CliExecutor.shellReader);
            mainCommandLine.usage(System.out);
            System.out.println();
            prompt = CliExecutor.formatAnsi("@|green " + mainCommandLine.getCommandName() + "|@$ ");
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        if ((line = CliExecutor.shellReader.readLine(prompt)) == null || line.isEmpty()) {
                            continue;
                        }
                        pl = CliExecutor.shellReader.getParser().parse(line, 0);
                        arguments = pl.words().toArray(new String[0]);
                        CliExecutor.execute(mainCommandLine, arguments);
                        System.out.println();
                    }
                }
                catch (UserInterruptException line) {
                }
                catch (EndOfFileException e) {
                    return;
                }
                catch (Exception e) {
                    CliExecutor.handleException(e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        ** GOTO lbl-1000
    }

    public static LineReader getOrCreateReader() throws IOException {
        return shellReader != null ? shellReader : LineReaderBuilder.builder().terminal(TerminalBuilder.builder().build()).parser((Parser)new DefaultParser()).build();
    }

    private static int handleException(Throwable e) {
        if (e instanceof CommandLine.ExecutionException && e.getCause() != null) {
            return CliExecutor.handleException(e.getCause());
        }
        if (e instanceof UserInterruptException) {
            return CliExecutor.handleException(CliCommandException.userError("Operation was interrupted by CTRL-C."));
        }
        if (e instanceof EndOfFileException) {
            return CliExecutor.handleException(CliCommandException.userError("Operation was aborted by CTRL-D."));
        }
        boolean userError = e instanceof CliCommandException && ((CliCommandException)e).isUserError();
        System.err.println();
        if (userError) {
            System.err.println(CliExecutor.formatAnsi("@|bold,fg(yellow) " + CliExecutor.getMessage(e) + "|@"));
        } else {
            System.err.println(CliExecutor.formatAnsi("@|bold,fg(red) [ERROR] " + CliExecutor.getMessage(e) + "|@"));
            if (!CliCommand.LOGGER.isLoggable(Level.FINE)) {
                System.err.println(CliExecutor.formatAnsi("@|bold - Configure com.gigaspaces.admin.cli log level for verbosity|@"));
            }
        }
        System.err.println();
        return CliExecutor.getExitCode(e);
    }

    private static String getMessage(Throwable e) {
        String message = e.getLocalizedMessage();
        return message != null ? message : e.toString();
    }

    private static int getExitCode(Throwable e) {
        return e instanceof CliCommandException ? ((CliCommandException)e).getExitCode() : 1;
    }

    private static CommandLine toCommandLine(Object command) {
        CommandLine cmd = new CommandLine(command);
        if (command instanceof SubCommandContainer) {
            for (Map.Entry<String, Object> entry : ((SubCommandContainer)command).getSubCommands().getCommands().entrySet()) {
                Object subcommand = entry.getValue();
                if (subcommand instanceof SubCommandContainer) {
                    subcommand = CliExecutor.toCommandLine(subcommand);
                }
                cmd.addSubcommand(entry.getKey(), subcommand);
            }
        }
        return cmd;
    }

    public static String formatAnsi(String s) {
        return CommandLine.Help.Ansi.AUTO.string(s);
    }

    @CommandLine.Command(name="cls", aliases={"clear"}, header={"Clears interactive shell terminal"})
    private static class ShellClearCommand
    extends CliCommand {
        private static final ShellClearCommand instance = new ShellClearCommand();
        private LineReaderImpl lineReader;

        private ShellClearCommand() {
        }

        @Override
        protected void execute() throws Exception {
            this.lineReader.clearScreen();
        }

        static /* synthetic */ ShellClearCommand access$100() {
            return instance;
        }

        static /* synthetic */ LineReaderImpl access$302(ShellClearCommand x0, LineReaderImpl x1) {
            x0.lineReader = x1;
            return x0.lineReader;
        }
    }

    @CommandLine.Command(name="exit", aliases={"quit"}, header={"Exits interactive shell (shortcut: CTRL-D)"})
    private static class ShellExitCommand
    extends CliCommand {
        private static final ShellExitCommand instance = new ShellExitCommand();

        private ShellExitCommand() {
        }

        @Override
        protected void execute() throws Exception {
            System.exit(0);
        }

        static /* synthetic */ ShellExitCommand access$200() {
            return instance;
        }
    }

    private static class PicocliJLineCompleter
    implements Completer {
        private final CommandLine.Model.CommandSpec spec;

        PicocliJLineCompleter(CommandLine.Model.CommandSpec spec) {
            this.spec = spec;
        }

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            String[] words = line.words().toArray(new String[0]);
            ArrayList cs = new ArrayList();
            AutoComplete.complete((CommandLine.Model.CommandSpec)this.spec, (String[])words, (int)line.wordIndex(), (int)0, (int)line.cursor(), cs);
            cs.forEach(c -> candidates.add(new Candidate((String)c)));
        }
    }

    private static class CustomRunner
    extends CommandLine.RunLast {
        private CustomRunner() {
        }

        protected List<Object> handle(CommandLine.ParseResult parseResult) throws CommandLine.ExecutionException {
            while (parseResult.hasSubcommand()) {
                parseResult = parseResult.subcommand();
            }
            CommandLine commandLine = parseResult.commandSpec().commandLine();
            Callable command = (Callable)commandLine.getCommand();
            try {
                if (commandLine == mainCommandLine) {
                    CliExecutor.executeShell(mainCommandLine);
                } else if (command instanceof SubCommandContainer) {
                    commandLine.usage(this.out());
                } else {
                    command.call();
                }
            }
            catch (CommandLine.ExecutionException | CommandLine.ParameterException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandLine.ExecutionException(commandLine, "Error while calling command (" + command + "): " + ex, (Throwable)ex);
            }
            return Collections.emptyList();
        }
    }
}

