/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import com.gigaspaces.start.GsCommandFactory;
import com.gigaspaces.start.JavaCommandBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;

public abstract class AbstractRunCommand
extends CliCommand {
    protected void validateOptions(int partitions, boolean ha, List<String> instances) throws CliCommandException {
        if (partitions == 0) {
            if (ha) {
                throw CliCommandException.userError("Missing argument: '--partitions' when used in conjunction with '--ha' option");
            }
            if (instances != null && !instances.isEmpty()) {
                throw CliCommandException.userError("Missing argument: '--partitions' when used in conjunction with '--instances' option");
            }
        } else if (partitions < 0) {
            throw CliCommandException.userError("Illegal argument: '--partitions=" + partitions + "' must be positive");
        }
    }

    protected static ProcessBuilder buildStartLookupServiceCommand() {
        return AbstractRunCommand.toProcessBuilder(new GsCommandFactory().lus(), "lookup service");
    }

    protected static ProcessBuilder toProcessBuilder(JavaCommandBuilder command, String desc) {
        ProcessBuilder processBuilder = command.toProcessBuilder();
        processBuilder.inheritIO();
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = "Starting " + desc + " with line:";
            String commandline = String.join((CharSequence)" ", processBuilder.command());
            LOGGER.fine(message + System.lineSeparator() + commandline + System.lineSeparator());
        }
        return processBuilder;
    }

    protected List<ProcessBuilder> toProcessBuilders(List<String> instances, int partitions, boolean ha, boolean lus) {
        ArrayList<ProcessBuilder> processBuilders = new ArrayList<ProcessBuilder>();
        if (lus) {
            processBuilders.add(AbstractRunCommand.buildStartLookupServiceCommand());
        }
        if (partitions == 0) {
            processBuilders.add(this.buildInstanceCommand(0, false));
        } else {
            for (int id = 1; id < partitions + 1; ++id) {
                if (instances == null) {
                    processBuilders.add(this.buildInstanceCommand(id, false));
                    if (!ha) continue;
                    processBuilders.add(this.buildInstanceCommand(id, true));
                    continue;
                }
                if (instances.remove(id + "_" + 1)) {
                    processBuilders.add(this.buildInstanceCommand(id, false));
                }
                if (!instances.remove(id + "_" + 2)) continue;
                processBuilders.add(this.buildInstanceCommand(id, true));
            }
        }
        return processBuilders;
    }

    protected abstract ProcessBuilder buildInstanceCommand(int var1, boolean var2);
}

