/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import com.gigaspaces.logger.LoggerSystemInfo;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gigaspaces.blueprints.Blueprint;
import org.gigaspaces.blueprints.BlueprintRepository;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.CommandsSet;
import org.gigaspaces.cli.SubCommandContainer;
import org.gigaspaces.cli.commands.BlueprintGenerateCommand;
import org.gigaspaces.cli.commands.BlueprintInfoCommand;
import org.gigaspaces.cli.commands.BlueprintListCommand;
import picocli.CommandLine;

@CommandLine.Command(name="blueprint", aliases={"bp"}, header={"List of available commands for blueprints"})
public class BlueprintCommand
extends CliCommand
implements SubCommandContainer {
    private static BlueprintRepository defaultRepository;

    @Override
    protected void execute() throws Exception {
    }

    @Override
    public CommandsSet getSubCommands() {
        return new CommandsSet().add(new BlueprintListCommand()).add(new BlueprintInfoCommand()).add(new BlueprintGenerateCommand());
    }

    static BlueprintRepository getDefaultRepository() throws IOException {
        if (defaultRepository == null) {
            defaultRepository = new BlueprintRepository(Paths.get(LoggerSystemInfo.xapHome, "config", "blueprints"));
        }
        return defaultRepository;
    }

    static Blueprint getBlueprint(String name) throws IOException, CliCommandException {
        if (name == null || name.length() == 0) {
            return null;
        }
        BlueprintRepository repository = BlueprintCommand.getDefaultRepository();
        Blueprint blueprint = repository.get(name);
        if (blueprint == null) {
            throw CliCommandException.userError("Unknown blueprint: " + name + ". Available blueprints: " + repository.getNames());
        }
        return blueprint;
    }

    static Blueprint getBlueprint(int id) throws IOException {
        return BlueprintCommand.getDefaultRepository().get(id);
    }

    public static class BlueprintCompletionCandidates
    extends ArrayList<String> {
        private static final Collection<String> names = BlueprintCompletionCandidates.getNames();

        public BlueprintCompletionCandidates() {
            super(names);
        }

        private static Collection<String> getNames() {
            try {
                return BlueprintCommand.getDefaultRepository().getNames();
            }
            catch (Exception e) {
                System.out.println("Warning: failed to get blueprints for autocomplete - " + e.getMessage());
                return Collections.emptyList();
            }
        }
    }
}

