/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.gigaspaces.blueprints.Blueprint;
import org.gigaspaces.blueprints.BlueprintRepository;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.CliExecutor;
import org.gigaspaces.cli.commands.BlueprintCommand;
import org.gigaspaces.cli.commands.utils.KeyValueFormatter;
import org.jline.reader.LineReader;
import picocli.CommandLine;

@CommandLine.Command(name="generate", header={"Generates a new GigaSpaces project from the specified blueprint"})
public class BlueprintGenerateCommand
extends CliCommand {
    @CommandLine.Parameters(index="0", description={"Blueprint name"}, arity="0..1", completionCandidates=BlueprintCommand.BlueprintCompletionCandidates.class)
    private String name;
    @CommandLine.Parameters(index="1", description={"Target path for generated project"}, arity="0..1")
    private Path target;
    @CommandLine.Option(names={"--set"}, description={"Set values on the command line (can specify multiple or separate values with commas: key1=val1,key2=val2)"}, split=",")
    private Map<String, Object> properties;
    @CommandLine.Option(names={"-i", "--interactive"}, description={"Set values on the command line (can specify multiple or separate values with commas: key1=val1,key2=val2)"})
    private Boolean interactive;

    @Override
    protected void execute() throws Exception {
        Blueprint blueprint = BlueprintCommand.getBlueprint(this.name);
        Path target = BlueprintGenerateCommand.assertNotExists(this.target);
        HashMap<String, Object> properties = this.properties != null ? this.properties : new HashMap<String, Object>();
        LineReader interactiveReader = this.initInteractive(blueprint, properties);
        if (interactiveReader == null) {
            if (blueprint == null) {
                throw CliCommandException.userError("Blueprint name was not provided and interactive mode is off");
            }
            if (target == null) {
                target = BlueprintGenerateCommand.getDefaultTarget(blueprint);
                System.out.println("Target not specified - auto-selected " + target);
            }
        } else {
            if (blueprint == null) {
                blueprint = BlueprintGenerateCommand.readBlueprint(interactiveReader);
            }
            if (target == null) {
                target = BlueprintGenerateCommand.readTarget(interactiveReader, BlueprintGenerateCommand.getDefaultTarget(blueprint));
            }
            BlueprintGenerateCommand.readProperties(interactiveReader, properties, blueprint.getValues());
        }
        blueprint.generate(target, properties);
        System.out.println(CliExecutor.formatAnsi(String.format("@|bold,fg(green) Generated project from %s at %s|@", blueprint.getName(), target.toAbsolutePath())));
        if (Desktop.isDesktopSupported() && interactiveReader != null && BlueprintGenerateCommand.readBoolean(interactiveReader, "Would you like to open it using the file explorer?", false)) {
            Desktop.getDesktop().open(target.toFile());
        }
    }

    private LineReader initInteractive(Blueprint blueprint, Map<String, Object> properties) throws IOException {
        String interactiveCause = this.interactive != null ? (this.interactive != false ? "interactive option was enabled" : null) : (blueprint == null ? "blueprint name was not provided" : (properties.size() == 0 ? "no properties were provided" : null));
        LineReader result = null;
        if (interactiveCause != null) {
            System.out.println("Generating blueprint in interactive mode (" + interactiveCause + ")...");
            result = CliExecutor.getOrCreateReader();
            System.out.println("Please provide a value for each of the following, or simply click ENTER to accept the default value in brackets.");
        }
        return result;
    }

    private static Blueprint readBlueprint(LineReader interactiveReader) throws CliCommandException, IOException {
        System.out.println("List of available blueprints: ");
        AtomicInteger counter = new AtomicInteger();
        KeyValueFormatter formatter = KeyValueFormatter.builder().build();
        BlueprintRepository repository = BlueprintCommand.getDefaultRepository();
        repository.getBlueprints().forEach(b -> formatter.append("[" + counter.incrementAndGet() + "] " + b.getName(), b.getDescription()));
        System.out.print(formatter.get());
        int defaultBlueprint = repository.indexOf("client").orElse(0) + 1;
        String input = BlueprintGenerateCommand.readString(interactiveReader, "Select a blueprint by name or number", defaultBlueprint);
        Optional<Integer> code = BlueprintGenerateCommand.isEmpty(input) ? Optional.of(defaultBlueprint) : BlueprintGenerateCommand.tryParse(input);
        return code.isPresent() ? BlueprintCommand.getBlueprint(code.get() - 1) : BlueprintCommand.getBlueprint(input);
    }

    private static Path readTarget(LineReader interactiveReader, Path defaultTarget) throws CliCommandException {
        String input = BlueprintGenerateCommand.readString(interactiveReader, "Target path", defaultTarget);
        Path result = !BlueprintGenerateCommand.isEmpty(input) ? Paths.get(input, new String[0]) : defaultTarget;
        return BlueprintGenerateCommand.assertNotExists(result);
    }

    private static void readProperties(LineReader interactiveReader, Map<String, Object> commandProperties, Map<String, String> blueprintProperties) {
        long missing = blueprintProperties.keySet().stream().filter(k -> !commandProperties.containsKey(k)).count();
        if (missing > 0L && BlueprintGenerateCommand.readBoolean(interactiveReader, "There are " + missing + " additional properties in this blueprint - would you like to set them?", false)) {
            AtomicInteger curr = new AtomicInteger();
            blueprintProperties.forEach((k, v) -> {
                if (!commandProperties.containsKey(k)) {
                    String input = BlueprintGenerateCommand.readString(interactiveReader, String.format("  (%s/%s) %s", curr.incrementAndGet(), missing, k), v);
                    commandProperties.put((String)k, input.isEmpty() ? v : input);
                }
            });
        }
    }

    private static String readString(LineReader reader, String label, Object defaultValue) {
        return reader.readLine(CliExecutor.formatAnsi(String.format("%s [@|bold %s|@]: ", label, defaultValue)));
    }

    private static boolean readBoolean(LineReader lineReader, String label, boolean defaultValue) {
        if (lineReader == null) {
            return defaultValue;
        }
        String input = BlueprintGenerateCommand.readString(lineReader, label, defaultValue ? "y" : "n");
        if (BlueprintGenerateCommand.isEmpty(input)) {
            return defaultValue;
        }
        switch (input.toLowerCase()) {
            case "y": 
            case "yes": {
                return true;
            }
        }
        return false;
    }

    private static Path getDefaultTarget(Blueprint blueprint) {
        String name = "my-" + blueprint.getName();
        int suffix = 1;
        Path path = Paths.get(name, new String[0]);
        while (Files.exists(path, new LinkOption[0])) {
            path = Paths.get(name + suffix++, new String[0]);
        }
        return path;
    }

    private static Path assertNotExists(Path path) throws CliCommandException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            throw CliCommandException.userError("Target path already exists: " + path);
        }
        return path;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static Optional<Integer> tryParse(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

