/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.logger.LoggerSystemInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;
import picocli.CommandLine;

@CommandLine.Command(name="install", header={"Installs GigaSpaces artifacts from this package to maven repository"})
public class MavenInstallCommand
extends CliCommand {
    @CommandLine.Option(names={"--artifacts-path"}, description={"Override default artifacts path"}, split=",")
    List<Path> artifactsPath;
    @CommandLine.Option(names={"--generate-only"}, description={"Generate the installer but don't run it"})
    boolean generateOnly;
    @CommandLine.Option(names={"--create-checksum"}, description={"Determines if checksum should be created"}, defaultValue="true")
    boolean createChecksum;
    @CommandLine.Option(names={"--maven-args"}, description={"Additional maven arguments for install command"})
    String mavenArguments = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws Exception {
        long startTime = System.currentTimeMillis();
        Path gsMaven = Paths.get(LoggerSystemInfo.xapHome, "config", "maven");
        if (this.artifactsPath == null) {
            this.artifactsPath = Collections.singletonList(gsMaven.resolve("gs-artifacts.txt"));
        }
        Path target = gsMaven.resolve("installer");
        System.out.println("Generating GigaSpaces Maven artifacts installer at " + target.toAbsolutePath() + "...");
        if (Files.exists(target, new LinkOption[0])) {
            throw new IOException("Path already exists: " + target.toAbsolutePath());
        }
        Files.createDirectory(target, new FileAttribute[0]);
        ArrayList<String> artifacts = new ArrayList<String>();
        for (Path path : this.artifactsPath) {
            artifacts.addAll(MavenInstallCommand.load(path));
        }
        this.generatePom(artifacts, target);
        if (this.generateOnly) {
            System.out.printf("Generated installer for %s artifacts - Run 'mvn install' from generated folder to install all artifacts.%n", artifacts.size());
        } else {
            try {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add(JavaUtils.isWindows() ? "mvn.cmd" : "mvn");
                commands.add("install");
                if (!this.mavenArguments.isEmpty()) {
                    commands.add(this.mavenArguments);
                }
                System.out.println("Executing install command: " + String.join((CharSequence)" ", commands));
                int exitCode = new ProcessBuilder(commands).directory(target.toAbsolutePath().toFile()).inheritIO().start().waitFor();
                if (exitCode != 0) {
                    throw CliCommandException.userError("Maven command exited with code " + exitCode);
                }
                float duration = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
                System.out.printf("Installation of GigaSpaces Maven artifacts completed (artifacts=%s, duration=%.2fs)%n", artifacts.size(), Float.valueOf(duration));
            }
            finally {
                MavenInstallCommand.deleteRecursive(target);
            }
        }
    }

    private void generatePom(List<String> artifacts, Path target) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<project>");
        lines.add("  <modelVersion>4.0.0</modelVersion>");
        lines.add("  <groupId>org.gigaspaces</groupId>");
        lines.add("  <artifactId>gs-maven-installer</artifactId>");
        lines.add("  <version>1.0</version>");
        lines.add("  <properties>");
        lines.add("    <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>");
        lines.add("    <gs.home>" + LoggerSystemInfo.xapHome + "</gs.home>");
        lines.add("    <createChecksum>" + this.createChecksum + "</createChecksum>");
        lines.add("  </properties>");
        lines.add("  <build>");
        lines.add("    <plugins>");
        lines.add("      <plugin>");
        lines.add("        <groupId>org.apache.maven.plugins</groupId>");
        lines.add("        <artifactId>maven-install-plugin</artifactId>");
        lines.add("        <version>2.5.2</version>");
        lines.add("        <executions>");
        List<String> template = MavenInstallCommand.createXmlTemplate();
        artifacts.forEach(artifact -> lines.addAll(this.processArtifact(template, target, (String)artifact)));
        lines.add("        </executions>");
        lines.add("      </plugin>");
        lines.add("    </plugins>");
        lines.add("  </build>");
        lines.add("</project>");
        Files.write(target.resolve("pom.xml"), lines, new OpenOption[0]);
    }

    private List<String> processArtifact(List<String> template, Path target, String artifact) {
        Path path = Paths.get(artifact.replace("${gs.home}", LoggerSystemInfo.xapHome), new String[0]);
        String fileName = path.getFileName().toString();
        String extension = MavenInstallCommand.getExtension(fileName);
        String name = fileName.substring(0, fileName.length() - extension.length());
        try {
            switch (extension) {
                case ".jar": {
                    MavenInstallCommand.extractPom(path, target.resolve("pom-" + name + ".xml"));
                    break;
                }
                case ".xml": {
                    artifact = "pom-" + name + ".xml";
                    Files.copy(path, target.resolve(artifact), new CopyOption[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported extension: " + extension);
                }
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{{name}}", name);
            placeholders.put("{{artifact}}", artifact);
            return template.stream().map(l -> MavenInstallCommand.replaceAll(l, placeholders)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getExtension(String s) {
        return s.substring(s.lastIndexOf(46));
    }

    private static List<String> createXmlTemplate() {
        ArrayList<String> template = new ArrayList<String>();
        template.add("          <execution>");
        template.add("            <id>install-{{name}}</id>");
        template.add("            <phase>package</phase>");
        template.add("            <goals>");
        template.add("              <goal>install-file</goal>");
        template.add("            </goals>");
        template.add("            <configuration>");
        template.add("              <file>{{artifact}}</file>");
        template.add("              <pomFile>pom-{{name}}.xml</pomFile>");
        template.add("              <createChecksum>${createChecksum}</createChecksum>");
        template.add("            </configuration>");
        template.add("          </execution>");
        return template;
    }

    private static List<String> load(Path path) throws IOException {
        try (Stream<String> stream = Files.lines(path);){
            List<String> list = stream.filter(s -> !s.startsWith("#")).collect(Collectors.toList());
            return list;
        }
    }

    private static String replaceAll(String s, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            s = s.replace(entry.getKey(), entry.getValue());
        }
        return s;
    }

    private static void extractPom(Path artifact, Path target) throws IOException {
        JarFile jar = new JarFile(artifact.toFile());
        JarEntry pomEntry = jar.stream().filter(e -> e.getName().startsWith("META-INF/maven") && e.getName().endsWith("pom.xml")).findFirst().orElseThrow(() -> new IOException("failed to find pom.xml for " + jar.getName()));
        MavenInstallCommand.extract(jar, pomEntry, target);
    }

    private static void extract(JarFile jar, JarEntry entry, Path target) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target.toFile()));){
            int nBytes;
            byte[] buffer = new byte[2048];
            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, nBytes);
            }
            ((OutputStream)out).flush();
        }
    }

    private static void deleteRecursive(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete " + p, e);
            }
        });
    }
}

