/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import com.gigaspaces.start.GsCommandFactory;
import com.gigaspaces.start.JavaCommandBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.commands.AbstractRunCommand;
import org.gigaspaces.cli.commands.utils.XapCliUtils;
import picocli.CommandLine;

@CommandLine.Command(name="run", header={"Run a standalone Processing Unit"})
public class PuRunCommand
extends AbstractRunCommand {
    @CommandLine.Parameters(index="0", description={"Relative/absolute path of a Processing Unit directory or archive file"})
    File path;
    @CommandLine.Option(names={"--partitions"}, description={"Specify the number of partitions for the Processing Unit"})
    int partitions;
    @CommandLine.Option(names={"--ha"}, description={"High availability (add one backup per partition)"})
    boolean ha;
    @CommandLine.Option(names={"--instances"}, split=",", description={"Specify one or more instances to run (for example: --instances=1_1,1_2). If no instances are specified, runs all instances."})
    List<String> instances;
    @CommandLine.Option(names={"--lus"}, description={"Start a lookup service"})
    boolean lus;
    @CommandLine.Option(names={"--properties"}, description={"Location of context level properties file"})
    File propertiesFilePath;
    @CommandLine.Option(names={"--property"}, description={"Context properties (for example: --property=k1=v1 --property=k2=v2)"})
    Map<String, String> properties;

    @Override
    protected void execute() throws Exception {
        this.validateOptions(this.partitions, this.ha, this.instances);
        if (!this.path.exists()) {
            throw CliCommandException.userError("File not found: " + this.path);
        }
        List<ProcessBuilder> processBuilders = this.toProcessBuilders(this.instances, this.partitions, this.ha, this.lus);
        if (this.instances != null && !this.instances.isEmpty()) {
            throw CliCommandException.userError("Invalid instances: " + this.instances.toString());
        }
        XapCliUtils.executeProcesses(processBuilders);
    }

    @Override
    protected ProcessBuilder buildInstanceCommand(int id, boolean backup) {
        JavaCommandBuilder command = new GsCommandFactory().standalonePuInstance().systemProperty("com.gs.start-embedded-lus", "false");
        command.arg("-path").arg(this.path.getPath());
        if (this.propertiesFilePath != null) {
            command.arg("-properties").arg("file://" + this.propertiesFilePath.getPath());
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            command.arg("-properties").arg("embed://" + PuRunCommand.join(this.properties));
        }
        if (id != 0) {
            command.arg("-cluster").arg("schema=partitioned").arg("total_members=" + this.partitions + "," + (this.ha ? "1" : "0")).arg("id=" + id).arg(backup ? "backup_id=1" : "");
        }
        return PuRunCommand.toProcessBuilder(command, "processing unit");
    }

    private static String join(Map<String, String> properties) {
        return properties.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).collect(Collectors.joining(";"));
    }
}

