/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands;

import com.gigaspaces.start.GsCommandFactory;
import com.gigaspaces.start.JavaCommandBuilder;
import java.util.List;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.commands.AbstractRunCommand;
import org.gigaspaces.cli.commands.utils.XapCliUtils;
import picocli.CommandLine;

@CommandLine.Command(name="run", header={"Run a standalone Space"})
public class SpaceRunCommand
extends AbstractRunCommand {
    @CommandLine.Parameters(index="0", description={"Name of Space to run"})
    public String name;
    @CommandLine.Option(names={"--partitions"}, description={"Specify the number of partitions for the Processing Unit"})
    public int partitions;
    @CommandLine.Option(names={"--ha"}, description={"High availability (add one backup per partition)"})
    public boolean ha;
    @CommandLine.Option(names={"--instances"}, split=",", description={"Specify one or more instances to run (for example: --instances=1_1,1_2). If no instances are specified, runs all instances."})
    List<String> instances;
    @CommandLine.Option(names={"--lus"}, description={"Start a lookup service"})
    public boolean lus;

    @Override
    protected void execute() throws Exception {
        this.validateOptions(this.partitions, this.ha, this.instances);
        List<ProcessBuilder> processBuilders = this.toProcessBuilders();
        if (this.instances != null && !this.instances.isEmpty()) {
            throw CliCommandException.userError("Invalid instances: " + this.instances.toString());
        }
        XapCliUtils.executeProcesses(processBuilders);
    }

    public List<ProcessBuilder> toProcessBuilders() {
        return this.toProcessBuilders(this.instances, this.partitions, this.ha, this.lus);
    }

    @Override
    protected ProcessBuilder buildInstanceCommand(int id, boolean isBackup) {
        JavaCommandBuilder command = new CommandBuilder(this.name).topology(this.partitions, this.ha).instance(id, isBackup).toCommand();
        return SpaceRunCommand.toProcessBuilder(command, "space");
    }

    public static class CommandBuilder {
        final String name;
        private int partitions;
        private boolean ha;
        private int partitionId;
        private boolean isBackupInstance;
        private String javaHeap;

        public CommandBuilder(String name) {
            this.name = name;
        }

        public CommandBuilder topology(int partitions, boolean ha) {
            this.partitions = partitions;
            this.ha = ha;
            return this;
        }

        public CommandBuilder instance(int partitionId, boolean isBackupInstance) {
            this.partitionId = partitionId;
            this.isBackupInstance = isBackupInstance;
            return this;
        }

        public JavaCommandBuilder toCommand() {
            JavaCommandBuilder command = new GsCommandFactory().spaceInstance().systemProperty("com.gs.start-embedded-lus", "false").heap(this.javaHeap);
            command.arg("-name").arg(this.name);
            if (this.partitionId != 0) {
                command.arg("-cluster").arg("schema=partitioned").arg("total_members=" + this.partitions + "," + (this.ha ? "1" : "0")).arg("id=" + this.partitionId).arg(this.isBackupInstance ? "backup_id=1" : "");
            }
            return command;
        }

        public CommandBuilder javaHeap(String javaHeap) {
            this.javaHeap = javaHeap;
            return this;
        }
    }
}

