/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands.utils;

public class KeyValueFormatter {
    private final StringBuilder sb = new StringBuilder();
    private final String format;

    private KeyValueFormatter(Builder builder) {
        this.format = "%-" + builder.width + "s" + builder.separator + "%s%n";
    }

    public KeyValueFormatter append(String key, Object value) {
        this.sb.append(String.format(this.format, key, value));
        return this;
    }

    public KeyValueFormatter append(String s) {
        this.sb.append(s);
        return this;
    }

    public KeyValueFormatter appendLineSeparator() {
        return this.append(System.lineSeparator());
    }

    public String get() {
        return this.sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int width = 16;
        private String separator = " ";

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public KeyValueFormatter build() {
            return new KeyValueFormatter(this);
        }
    }
}

