/*
 * Decompiled with CFR 0.152.
 */
package org.gigaspaces.cli.commands.utils;

import com.gigaspaces.logger.GSLogConfigLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gigaspaces.cli.commands.utils.ProcessBuilderWrapper;

public class XapCliUtils {
    private static Logger LOGGER;
    private static final String PROCESS_TERMINATION_TIMEOUT = "com.gs.cli.process-termination-timeout";
    private static final long processTimeoutInSeconds;
    public static final String DEMO_SPACE_NAME = "demo";
    public static final String INSIGHTEDGE_DEMO_SPACE_NAME = "demo";

    public static void executeProcessesWrapper(List<ProcessBuilderWrapper> processBuilderWrappers) throws InterruptedException {
        ExecutorService executorService = Executors.newCachedThreadPool();
        XapCliUtils.addShutdownHookToKillSubProcessesOnExit(executorService, processBuilderWrappers);
        int TIMEOUT = Integer.MAX_VALUE;
        for (final ProcessBuilderWrapper processBuilderWrapper : processBuilderWrappers) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        long startTime = System.currentTimeMillis();
                        while (!processBuilderWrapper.allowToStart()) {
                            Thread.sleep(500L);
                            if (System.currentTimeMillis() - startTime <= Integer.MAX_VALUE) continue;
                        }
                        Process process = processBuilderWrapper.start();
                        process.waitFor();
                        if (processBuilderWrapper.isSyncCommand()) {
                            System.exit(process.exitValue());
                        }
                    }
                    catch (IOException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                    catch (InterruptedException e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e.toString(), e);
                        }
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public static void executeProcesses(List<ProcessBuilder> processBuilders) throws InterruptedException {
        XapCliUtils.executeProcessesWrapper(XapCliUtils.wrapList(processBuilders));
    }

    public static void executeProcess(ProcessBuilder processBuilder) throws InterruptedException {
        XapCliUtils.executeProcesses(Collections.singletonList(processBuilder));
    }

    private static List<ProcessBuilderWrapper> wrapList(List<ProcessBuilder> lst) {
        ArrayList<ProcessBuilderWrapper> wrappedList = new ArrayList<ProcessBuilderWrapper>(lst.size());
        for (ProcessBuilder cur : lst) {
            wrappedList.add(new ProcessBuilderWrapper(cur));
        }
        return wrappedList;
    }

    public static void addShutdownHookToKillSubProcessesOnExit(final ExecutorService executorService, final List<ProcessBuilderWrapper> processBuilderWrappers) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                long deadline = start + processTimeoutInSeconds * 1000L;
                int destroyed = 0;
                int zombies = 0;
                executorService.shutdown();
                ArrayList<Process> processes = new ArrayList<Process>();
                for (ProcessBuilderWrapper processBuilderWrapper : processBuilderWrappers) {
                    Process process = processBuilderWrapper.destroy();
                    if (process == null) continue;
                    if (process.isAlive()) {
                        processes.add(process);
                        continue;
                    }
                    ++destroyed;
                }
                if (!processes.isEmpty()) {
                    System.out.println("Shutdown in progress, waiting " + processTimeoutInSeconds + " seconds for sub-processes to stop (configure timeout duration via the " + XapCliUtils.PROCESS_TERMINATION_TIMEOUT + " system property)");
                    for (Process process : processes) {
                        if (this.killProcess(process, deadline)) {
                            ++destroyed;
                            continue;
                        }
                        ++zombies;
                    }
                }
                long duration = System.currentTimeMillis() - start;
                if (zombies == 0) {
                    System.out.printf("Shutdown completed successfully - %d sub-processes were terminated (duration: %dms)%n", destroyed, duration);
                } else {
                    System.err.println("Shutdown did not complete before the timeout (" + processTimeoutInSeconds + " seconds) elapsed - " + destroyed + " sub-processes were terminated but " + zombies + " sub-processes might still be running");
                }
            }

            private boolean killProcess(Process process, long deadline) {
                long timeout = deadline - System.currentTimeMillis();
                if (timeout < 1L) {
                    timeout = 1L;
                }
                try {
                    if (process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                        return true;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                process.destroyForcibly();
                return !process.isAlive();
            }
        });
    }

    static {
        processTimeoutInSeconds = Long.getLong(PROCESS_TERMINATION_TIMEOUT, 60L);
        GSLogConfigLoader.getLoader((String)"cli");
        LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    }
}

