/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.offheap;

import com.gigaspaces.blobstore.offheap.OffHeapBlobStoreStatistics;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationType;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.memory_pool.OffHeapMemoryPool;
import com.j_spaces.core.cache.blobStore.offheap.OffHeapStorageContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class OffHeapBlobStoreHandler
extends BlobStoreStorageHandler
implements OffHeapStorageContainer {
    private final AbstractMemoryPool memoryPool;
    private static final Logger logger = Logger.getLogger("com.gigaspaces.cache");

    public OffHeapBlobStoreHandler(long memoryThreshold) {
        this.memoryPool = new OffHeapMemoryPool(memoryThreshold);
    }

    public Object add(Serializable id, Serializable data, BlobStoreObjectType objectType) {
        this.memoryPool.write((IBlobStoreOffHeapInfo)id, (byte[])data);
        return id;
    }

    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType) {
        return this.memoryPool.get((IBlobStoreOffHeapInfo)id);
    }

    public Object replace(Serializable id, Serializable data, Object position, BlobStoreObjectType objectType) {
        this.memoryPool.update((IBlobStoreOffHeapInfo)id, (byte[])data);
        return position;
    }

    public Serializable remove(Serializable id, Object position, BlobStoreObjectType objectType) {
        this.memoryPool.delete((IBlobStoreOffHeapInfo)id);
        return null;
    }

    public List<BlobStoreBulkOperationResult> executeBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        ArrayList<BlobStoreBulkOperationResult> result = new ArrayList<BlobStoreBulkOperationResult>(operations.size());
        for (BlobStoreBulkOperationRequest request : operations) {
            if (request.getOpType() == BlobStoreBulkOperationType.ADD) {
                try {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreAddBulkOperationResult(request.getId(), this.add((Serializable)request.getOffHeapInfo(), request.getData(), objectType)));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreAddBulkOperationResult(request.getId(), (Throwable)ex));
                }
                continue;
            }
            if (request.getOpType() == BlobStoreBulkOperationType.REMOVE) {
                try {
                    this.remove((Serializable)request.getOffHeapInfo(), request.getPosition(), objectType);
                    result.add((BlobStoreBulkOperationResult)new BlobStoreRemoveBulkOperationResult(request.getId()));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreRemoveBulkOperationResult(request.getId(), (Throwable)ex));
                }
                continue;
            }
            if (request.getOpType() == BlobStoreBulkOperationType.REPLACE) {
                try {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreReplaceBulkOperationResult(request.getId(), this.replace((Serializable)request.getOffHeapInfo(), request.getData(), request.getPosition(), objectType), request.getOffHeapInfo()));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreReplaceBulkOperationResult(request.getId(), (Throwable)ex));
                }
                continue;
            }
            if (request.getOpType() != BlobStoreBulkOperationType.GET) continue;
            try {
                result.add((BlobStoreBulkOperationResult)new BlobStoreGetBulkOperationResult(request.getId(), this.get((Serializable)request.getOffHeapInfo(), request.getPosition(), objectType), request.getPosition(), request.getOffHeapInfo()));
            }
            catch (Exception ex) {
                result.add((BlobStoreBulkOperationResult)new BlobStoreGetBulkOperationResult(request.getId(), (Throwable)ex));
            }
        }
        return result;
    }

    public void initialize(BlobStoreConfig blobStoreConfig) {
        LicenseManager.getInstance().validate("MemoryXtend OffHeap plug-in", LicenseType.ENTERPRISE);
        logger.info("Off Heap Storage Handler [ " + ((Object)((Object)this)).getClass().getName() + " ] initialized on space: " + blobStoreConfig.getSpaceName() + ", memory threshold = " + this.getMemoryPool().getThreshold() + "B");
    }

    public BlobStoreStorageStatistics getStatistics() {
        return new OffHeapBlobStoreStatistics().setUsedBytes(this.memoryPool.getUsedBytes());
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("blobstore.offheap.memory", String.valueOf(this.memoryPool.getThreshold()));
        return props;
    }

    public AbstractMemoryPool getMemoryPool() {
        return this.memoryPool;
    }
}

