/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.offheap.config;

import com.gigaspaces.blobstore.offheap.OffHeapBlobStoreHandler;
import com.gigaspaces.internal.utils.StringUtils;

public class OffHeapBlobStoreConfigurer {
    private OffHeapBlobStoreHandler offHeapBlobStoreHandler;
    private String memoryThreshold;

    public OffHeapBlobStoreConfigurer setMemoryThreshold(String memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        return this;
    }

    public OffHeapBlobStoreHandler create() {
        if (this.offHeapBlobStoreHandler != null) {
            return this.offHeapBlobStoreHandler;
        }
        System.setProperty("space-config.engine.blobstore_use_bulks", "false");
        if (this.memoryThreshold == null) {
            throw new IllegalArgumentException("Please configure memoryThreshold. it's a required property.");
        }
        this.offHeapBlobStoreHandler = new OffHeapBlobStoreHandler(StringUtils.parseStringAsBytes((String)this.memoryThreshold));
        return this.offHeapBlobStoreHandler;
    }

    public OffHeapBlobStoreHandler storageHandler() {
        return this.create();
    }
}

