/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.client.cache.SpaceCacheException;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.SpaceCacheState;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.kernel.log.JProperties;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSpaceCache {
    protected final Logger _logger = this.initLogger();
    private final AbstractSpaceCacheContainer _cacheContainer;
    protected final String _cacheID;
    protected final IDirectSpaceProxy _remoteSpace;
    private SpaceImpl _localSpaceImpl;
    protected IDirectSpaceProxy _localSpace;
    private EntryDataType _cacheEntryDataType;

    protected AbstractSpaceCache(AbstractSpaceCacheContainer cacheContainer) {
        this._cacheContainer = cacheContainer;
        this._cacheID = cacheContainer.getCacheId();
        this._remoteSpace = cacheContainer.getRemoteSpace();
    }

    public void initialize() throws SpaceInitializationException, InterruptedException {
        try {
            this._localSpaceImpl = this.createLocalSpaceImpl(this._cacheContainer.getRemoteSpace(), this._cacheContainer.getCacheConfig());
            this._localSpace = this._localSpaceImpl.getSingleProxy();
            this._localSpace.setReadModifiers(this._cacheContainer.getReadModifiers());
            this._localSpace.setUpdateModifiers(this._cacheContainer.getUpdateModifiers());
            this._cacheEntryDataType = this._localSpaceImpl.getEngine().getEntryDataType();
        }
        catch (RemoteException e) {
            throw new SpaceCacheInitializationException("Failed to initialize space cache", e);
        }
    }

    public void close() {
        block4: {
            if (this._localSpace != null) {
                this._localSpace.close();
                this._localSpace = null;
            }
            if (this._localSpaceImpl != null) {
                try {
                    this._localSpaceImpl.shutdown(true, false);
                    this._localSpaceImpl = null;
                }
                catch (Exception e) {
                    if (!this._logger.isLoggable(Level.FINE)) break block4;
                    this._logger.log(Level.FINE, this._cacheID + " failed to close", e);
                }
            }
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    protected abstract Logger initLogger();

    public void onCacheFailure() {
        this._cacheContainer.onCacheFailure(this);
    }

    public boolean isClosed() {
        return this._cacheContainer.getCacheState() == SpaceCacheState.CLOSED;
    }

    public SpaceImpl getLocalSpaceImpl() {
        SpaceImpl localSpaceImpl = this._localSpaceImpl;
        if (localSpaceImpl == null) {
            throw new SpaceCacheException(this._cacheID + " is disconnected.");
        }
        return localSpaceImpl;
    }

    public IDirectSpaceProxy getLocalProxy() {
        IDirectSpaceProxy localSpace = this._localSpace;
        if (localSpace == null) {
            throw new SpaceCacheException(this._cacheID + " is disconnected.");
        }
        return localSpace;
    }

    public IDirectSpaceProxy getRemoteProxy() {
        return this._remoteSpace;
    }

    public EntryDataType getCacheEntryDataType() {
        return this._cacheEntryDataType;
    }

    private SpaceImpl createLocalSpaceImpl(IDirectSpaceProxy remoteProxy, SpaceCacheConfig config) throws SpaceInitializationException {
        try {
            String cacheSuffix = this.getCacheSuffix();
            SpaceConfigReader configReader = JProperties.loadDCacheConfig((ISpaceProxy)remoteProxy, (Properties)config.getCustomProperties(), (String)cacheSuffix);
            config.initLocalSpaceConfig(configReader);
            JSpaceAttributes spaceConfig = new JSpaceAttributes();
            spaceConfig.setPrivate(true);
            return new SpaceImpl(remoteProxy.getName() + cacheSuffix, remoteProxy.getContainerName(), null, config.getRemoteSpaceUrl(), spaceConfig, config.getRemoteSpaceUrl().getCustomProperties(), true, false, null);
        }
        catch (CreateException e) {
            throw new SpaceCacheInitializationException("Failed to create local space: " + e.getMessage(), e);
        }
        catch (RemoteException e) {
            throw new SpaceCacheInitializationException("Failed to create local space: " + e.getMessage(), e);
        }
    }

    protected abstract String getCacheSuffix();

    public abstract boolean isHealthy();

    public SpaceCacheInitializationException getInitializationException() {
        return null;
    }
}

