/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.client.cache.SpaceCacheException;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.SpaceCacheState;
import com.gigaspaces.internal.client.spaceproxy.AbstractSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.ActionListener;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.client.SpaceURL;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.id.Uuid;

public abstract class AbstractSpaceCacheContainer
extends AbstractSpaceProxy
implements ISpaceCache {
    private static final AtomicInteger _cacheIdGenerator = new AtomicInteger();
    protected final Logger _logger = this.initLogger();
    private final SpaceCacheConfig _config;
    private IDirectSpaceProxy _remoteSpace;
    protected final String _cacheID;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final boolean _activeWhileDisconnected;
    private final StateMonitor _stateMonitor;
    private long _retriesInterval;
    private final Object _stateLock;
    private volatile SpaceCacheState _state;
    private volatile AbstractSpaceCache _cache;
    private volatile IAsyncHandler _stateMonitorAsyncHandler;
    private int _readModifiers;
    private int _updateModifiers;

    protected AbstractSpaceCacheContainer(IDirectSpaceProxy remoteProxy, SpaceCacheConfig config) {
        this._remoteSpace = remoteProxy;
        this._config = config;
        this._config.initRemoteSpaceUrl(remoteProxy);
        this._cacheID = this.getCacheTypeName() + "#" + _cacheIdGenerator.incrementAndGet() + "-" + this._remoteSpace.getName();
        this._asyncHandlerProvider = new ScheduledThreadPoolAsyncHandlerProvider("SpaceCacheStateMonitor-" + this._cacheID, 1);
        this._activeWhileDisconnected = config.isActiveWhileDisconnected();
        this._stateMonitor = new StateMonitor();
        this._stateLock = new Object();
        this._state = SpaceCacheState.DISCONNECTED;
        this._readModifiers = this._remoteSpace.getReadModifiers();
        this._updateModifiers = this._remoteSpace.getUpdateModifiers();
    }

    protected abstract Logger initLogger();

    public void verifyProjectionsAreSupported(AbstractProjectionTemplate projectionTemplate) {
        if (projectionTemplate != null && this._config.getEntryDataType() == EntryDataType.USER_TYPE) {
            throw new UnsupportedOperationException(this.getCacheTypeName() + " doesn't support projections since it might cause a drop in performance - use a non projected query instead");
        }
    }

    public String getCacheId() {
        return this._cacheID;
    }

    public SpaceCacheState getCacheState() {
        return this._state;
    }

    public abstract SpaceCacheConfig getCacheConfig();

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public String toString() {
        return this._cacheID;
    }

    public void close() {
        this.updateCacheAndState(null, SpaceCacheState.CLOSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceCacheState updateCacheAndState(AbstractSpaceCache newCache, SpaceCacheState newState) {
        Object object = this._stateLock;
        synchronized (object) {
            this.notifyLocalSpaceOnInternalStateChange(newState);
            if (this._state == SpaceCacheState.CLOSED) {
                if (newCache != null) {
                    newCache.close();
                }
            } else {
                AbstractSpaceCache oldCache = this._cache;
                this._cache = newCache;
                this._state = newState;
                if (newState == SpaceCacheState.CLOSED) {
                    if (this._stateMonitorAsyncHandler != null) {
                        this._stateMonitorAsyncHandler.stop(3L, TimeUnit.SECONDS);
                    }
                    this._asyncHandlerProvider.close();
                }
                if (oldCache != null) {
                    oldCache.close();
                }
            }
            return this._state;
        }
    }

    private AbstractSpaceCache getCacheIfConnected(boolean wakeupMonitorIfNeeded) throws SpaceCacheException {
        AbstractSpaceCache cache = this._cache;
        SpaceCacheState state = this._state;
        if (state == SpaceCacheState.CONNECTED) {
            if (cache != null && cache.isHealthy()) {
                return cache;
            }
            if (wakeupMonitorIfNeeded && this._stateMonitorAsyncHandler != null) {
                this._stateMonitorAsyncHandler.wakeUp();
            }
            return null;
        }
        if (state == SpaceCacheState.CONNECTING || state == SpaceCacheState.DISCONNECTED) {
            return null;
        }
        if (state == SpaceCacheState.CLOSED) {
            throw new SpaceCacheException(this._cacheID + " is closed.");
        }
        throw new SpaceCacheException(this._cacheID + " state is not supported: " + (Object)((Object)state));
    }

    public AbstractSpaceCache assertCacheConnected() throws SpaceCacheException {
        AbstractSpaceCache result = this.getCacheIfConnected(true);
        if (result != null || this._activeWhileDisconnected) {
            return result;
        }
        throw new SpaceCacheException(this._cacheID + " is inactive.");
    }

    public IDirectSpaceProxy getLocalSpace() {
        return this.assertCacheConnected().getLocalProxy();
    }

    public IDirectSpaceProxy getRemoteSpace() {
        return this._remoteSpace;
    }

    public void initialize() throws SpaceCacheInitializationException {
        try {
            this.restart(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SpaceCacheInitializationException("Space Cache restart interrupted", e);
        }
        this._retriesInterval = Math.max(this._config.getMaxDisconnectionDuration() / 10L, 1000L);
        this._stateMonitorAsyncHandler = this._asyncHandlerProvider.start((AsyncCallable)this._stateMonitor, this._retriesInterval, "LocalViewStateMonitor", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheFailure(AbstractSpaceCache failedCache) {
        Object object = this._stateLock;
        synchronized (object) {
            if (failedCache != this._cache) {
                return;
            }
            this._stateMonitor.onCacheFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceCacheState restart(boolean firstTime) throws InterruptedException {
        SpaceCacheState newState;
        if (this.updateCacheAndState(null, SpaceCacheState.CONNECTING) == SpaceCacheState.CLOSED) {
            return SpaceCacheState.CLOSED;
        }
        AbstractSpaceCache newCache = null;
        try {
            newCache = this.tryCreateCache();
            newState = newCache != null ? SpaceCacheState.CONNECTED : SpaceCacheState.DISCONNECTED;
        }
        catch (Throwable throwable) {
            SpaceCacheState newState2 = newCache != null ? SpaceCacheState.CONNECTED : SpaceCacheState.DISCONNECTED;
            newState2 = this.updateCacheAndState(newCache, newState2);
            if (newState2 == SpaceCacheState.CONNECTED) {
                SpaceCacheInitializationException exception = newCache.getInitializationException();
                if (exception != null) {
                    newState2 = this.updateCacheAndState(null, SpaceCacheState.DISCONNECTED);
                } else {
                    Level logLevel;
                    Level level = logLevel = firstTime ? Level.FINE : Level.INFO;
                    if (this._logger.isLoggable(logLevel)) {
                        this._logger.log(logLevel, this._cacheID + " is active.");
                    }
                }
            }
            throw throwable;
        }
        newState = this.updateCacheAndState(newCache, newState);
        if (newState == SpaceCacheState.CONNECTED) {
            SpaceCacheInitializationException exception = newCache.getInitializationException();
            if (exception != null) {
                newState = this.updateCacheAndState(null, SpaceCacheState.DISCONNECTED);
            } else {
                Level logLevel;
                Level level = logLevel = firstTime ? Level.FINE : Level.INFO;
                if (this._logger.isLoggable(logLevel)) {
                    this._logger.log(logLevel, this._cacheID + " is active.");
                }
            }
        }
        return newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSpaceCache tryCreateCache() throws InterruptedException {
        AbstractSpaceCache cache = null;
        boolean isSuccessful = false;
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, this._cacheID + " is searching for remote space: " + this._config.getRemoteSpaceUrl().getURL());
            }
            if (!this._remoteSpace.checkIfConnected()) {
                CredentialsProvider credentialsProvider = this._remoteSpace.getSecurityManager().getCredentialsProvider();
                this._remoteSpace = (IDirectSpaceProxy)SpaceFinder.find((SpaceURL)this._config.getRemoteSpaceUrl(), (CredentialsProvider)credentialsProvider);
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, this._cacheID + " has located remote space, attempting to reconnect...");
            }
            cache = this.createSpaceCache();
            cache.initialize();
            isSuccessful = true;
        }
        catch (FinderException e) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, this._cacheID + " failed to find remote space: " + this._config.getRemoteSpaceUrl().getURL());
            }
        }
        catch (SpaceInitializationException e) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, this._cacheID + " failed to initialize", e);
            }
        }
        finally {
            if (!isSuccessful && cache != null) {
                cache.close();
                cache = null;
            }
        }
        if (cache == null && this._logger.isLoggable(Level.SEVERE)) {
            this._logger.log(Level.SEVERE, this._cacheID + " is inactive.");
        }
        return cache;
    }

    protected abstract AbstractSpaceCache createSpaceCache() throws SpaceCacheInitializationException;

    public boolean isEmbedded() {
        return this._remoteSpace.isEmbedded();
    }

    public boolean isClustered() {
        return this._remoteSpace.isClustered();
    }

    public boolean isSecured() {
        return this._remoteSpace.isSecured();
    }

    public boolean isServiceSecured() throws RemoteException {
        return this._remoteSpace.isServiceSecured();
    }

    public boolean isStartedWithinGSC() throws RemoteException {
        return this._remoteSpace.isStartedWithinGSC();
    }

    public String getName() {
        return this._remoteSpace.getName();
    }

    public SpaceURL getFinderURL() {
        return this._remoteSpace.getFinderURL();
    }

    public SpaceURL getURL() {
        return this._remoteSpace.getURL();
    }

    public Uuid getReferentUuid() {
        return this._remoteSpace.getReferentUuid();
    }

    public Object getAdmin() throws RemoteException {
        return this._remoteSpace.getAdmin();
    }

    public IDirectSpaceProxy getDirectProxy() {
        return this._remoteSpace;
    }

    public Object getPrivilegedAdmin() throws RemoteException {
        return this._remoteSpace.getPrivilegedAdmin();
    }

    public boolean isFifo() {
        return this._remoteSpace.isFifo();
    }

    public void setFifo(boolean enabled) {
        this._remoteSpace.setFifo(enabled);
    }

    public boolean isOptimisticLockingEnabled() {
        return this._remoteSpace.isOptimisticLockingEnabled();
    }

    public void setOptimisticLocking(boolean enabled) {
        this._remoteSpace.setOptimisticLocking(enabled);
    }

    public int initWriteModifiers(int modifiers) {
        return this._remoteSpace.initWriteModifiers(modifiers);
    }

    public Transaction.Created getContextTransaction() {
        return this._remoteSpace.getContextTransaction();
    }

    public Transaction.Created replaceContextTransaction(Transaction.Created transaction) {
        return this._remoteSpace.replaceContextTransaction(transaction);
    }

    public Transaction.Created replaceContextTransaction(Transaction.Created transaction, ActionListener actionListener, boolean delegatedXa) {
        return this._remoteSpace.replaceContextTransaction(transaction, actionListener, delegatedXa);
    }

    public void setActionListener(ActionListener actionListener) {
        this._remoteSpace.setActionListener(actionListener);
    }

    public int getReadModifiers() {
        return this._readModifiers;
    }

    public int setReadModifiers(int modifiers) {
        int oldModifiers = this._readModifiers;
        this._readModifiers = modifiers;
        AbstractSpaceCache cache = this._cache;
        if (cache != null) {
            cache.getLocalProxy().setReadModifiers(modifiers);
        }
        return oldModifiers;
    }

    public int getUpdateModifiers() {
        return this._updateModifiers;
    }

    public int setUpdateModifiers(int modifiers) {
        int oldModifiers = this._updateModifiers;
        this._updateModifiers = modifiers;
        AbstractSpaceCache cache = this._cache;
        if (cache != null) {
            cache.getLocalProxy().setUpdateModifiers(modifiers);
        }
        return oldModifiers;
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        return this._remoteSpace.login(credentialsProvider);
    }

    public Class<?> loadRemoteClass(String className) throws ClassNotFoundException {
        return this._remoteSpace.loadRemoteClass(className);
    }

    public OperationID createNewOperationID() {
        AbstractSpaceCache cache = this._cache;
        if (cache != null) {
            return cache.getLocalProxy().createNewOperationID();
        }
        return this._remoteSpace.createNewOperationID();
    }

    public Object readById(ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ITemplatePacket packet = actionInfo.queryPacket;
        Object result = this.readByIdFromCache(packet.getTypeName(), packet.getID(), actionInfo.txn, actionInfo.queryPacket.getQueryResultType());
        if (result != null) {
            if (this._config.getEntryDataType() == EntryDataType.FLAT && actionInfo.queryPacket.getProjectionTemplate() != null) {
                actionInfo.queryPacket.getProjectionTemplate().filterOutNonProjectionProperties((IEntryPacket)result);
            }
            return result;
        }
        return super.readById(actionInfo);
    }

    public Object readById(String className, Object id, Object routing, Transaction txn, long timeout, int modifiers, boolean ifExists, QueryResultTypeInternal resultType, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        Object result = this.readByIdFromCache(className, id, txn, resultType);
        if (result != null) {
            return result;
        }
        return super.readById(className, id, routing, txn, timeout, modifiers, ifExists, resultType, projections);
    }

    private Object readByIdFromCache(String className, Object id, Transaction txn, QueryResultTypeInternal resultType) {
        if (txn == null) {
            Object result;
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null.");
            }
            if (className == null) {
                throw new IllegalArgumentException("className cannot be null.");
            }
            AbstractSpaceCache cache = this._cache;
            if (cache != null && (result = cache.getLocalSpaceImpl().getEngine().directLocalReadById(id, className, resultType)) != null) {
                return result;
            }
        }
        return null;
    }

    public boolean isCacheContainer() {
        return true;
    }

    protected void notifyLocalSpaceOnInternalStateChange(SpaceCacheState state) {
    }

    public class StateMonitor
    extends AsyncCallable {
        private volatile boolean _pendingCacheFailure;

        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            if (!this._pendingCacheFailure) {
                try {
                    AbstractSpaceCache cache = AbstractSpaceCacheContainer.this.getCacheIfConnected(false);
                    if (cache != null) {
                        return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                    }
                }
                catch (SpaceCacheException e) {
                    return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                }
            }
            if (AbstractSpaceCacheContainer.this._logger.isLoggable(Level.WARNING)) {
                AbstractSpaceCacheContainer.this._logger.log(Level.WARNING, AbstractSpaceCacheContainer.this._cacheID + " lost connection to remote space - attempting to reconnect...");
            }
            this._pendingCacheFailure = false;
            SpaceCacheState state = AbstractSpaceCacheContainer.this.restart(false);
            if (state == SpaceCacheState.CLOSED) {
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
            if (state != SpaceCacheState.CONNECTED) {
                this._pendingCacheFailure = true;
                if (AbstractSpaceCacheContainer.this._logger.isLoggable(Level.WARNING)) {
                    AbstractSpaceCacheContainer.this._logger.log(Level.WARNING, AbstractSpaceCacheContainer.this._cacheID + " failed to connect to remote space - waiting " + AbstractSpaceCacheContainer.this._retriesInterval + " millis before next attempt...");
                }
            }
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }

        public void onCacheFailure() {
            this._pendingCacheFailure = true;
            if (AbstractSpaceCacheContainer.this._stateMonitorAsyncHandler != null) {
                AbstractSpaceCacheContainer.this._stateMonitorAsyncHandler.wakeUp();
            }
        }
    }
}

