/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.NotifySpaceCacheStateListener;
import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceInitializationException;
import java.util.logging.Level;
import net.jini.lease.LeaseListener;

public abstract class NotifySpaceCache
extends AbstractSpaceCache {
    private final AbstractSpaceCacheContainer _cacheContainer;
    private final NotifySpaceCacheStateListener _stateListener;
    protected AbstractDataEventSession _eventSession;

    protected NotifySpaceCache(AbstractSpaceCacheContainer cacheContainer) {
        super(cacheContainer);
        this._cacheContainer = cacheContainer;
        this._stateListener = new NotifySpaceCacheStateListener(this, cacheContainer.getCacheConfig());
    }

    @Override
    public void initialize() throws SpaceInitializationException, InterruptedException {
        super.initialize();
        this._localSpace.setOptimisticLocking(true);
        this._eventSession = this.initDataEventSession();
    }

    @Override
    public void close() {
        block3: {
            try {
                if (this._eventSession != null) {
                    this._eventSession.close();
                    this._eventSession = null;
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.FINE)) break block3;
                this._logger.log(Level.FINE, "Failed to close event session", e);
            }
        }
        super.close();
    }

    @Override
    public boolean isHealthy() {
        return this._stateListener.isHealthy();
    }

    private AbstractDataEventSession initDataEventSession() {
        SpaceCacheConfig cacheConfig = this._cacheContainer.getCacheConfig();
        if (!cacheConfig.supportsNotifications()) {
            return null;
        }
        EventSessionConfig config = new EventSessionConfig();
        config.setFifo(this.useFifoEventListeners());
        config.setBatch(cacheConfig.getBatchSize().intValue(), cacheConfig.getBatchTimeout().longValue());
        config.setAutoRenew(true, (LeaseListener)this._stateListener);
        return (AbstractDataEventSession)DataEventSessionFactory.create((IJSpace)this._remoteSpace, (EventSessionConfig)config);
    }

    protected abstract boolean useFifoEventListeners();

    @Override
    protected String getCacheSuffix() {
        return "_DCache";
    }
}

