/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.internal.client.cache.NotifySpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.LeaseException;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

public class NotifySpaceCacheStateListener
implements LeaseListener,
Runnable {
    private final NotifySpaceCache _spaceCache;
    private final SpaceCacheConfig _cacheConfig;
    private final Logger _logger;
    private final Object _lock;
    private volatile long _disconnectTime;
    private GSThread _monitorThread;

    public NotifySpaceCacheStateListener(NotifySpaceCache spaceCache, SpaceCacheConfig cacheConfig) {
        this._spaceCache = spaceCache;
        this._cacheConfig = cacheConfig;
        this._logger = spaceCache.getLogger();
        this._lock = new Object();
    }

    public boolean isHealthy() {
        long disconnectTime = this._disconnectTime;
        if (disconnectTime == 0L) {
            return true;
        }
        long disconnectDuration = SystemTime.timeMillis() - disconnectTime;
        return disconnectDuration < this._cacheConfig.getMaxDisconnectionDuration();
    }

    public void notify(LeaseRenewalEvent event) {
        block5: {
            try {
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.warning("Failed to renew local space notify lease - LeaseRenewalEvent: \n event cause: " + event.getException() + '\n');
                }
                if (event.getException() instanceof LeaseException) {
                    this._spaceCache.onCacheFailure();
                } else {
                    this.setDisconnected();
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block5;
                this._logger.log(Level.SEVERE, "Failed to process lease renewal event", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisconnected() {
        Object object = this._lock;
        synchronized (object) {
            if (this._disconnectTime == 0L) {
                this._disconnectTime = System.currentTimeMillis();
                this._monitorThread = new GSThread((Runnable)this);
                this._monitorThread.start();
            }
        }
    }

    @Override
    public void run() {
        block3: {
            try {
                while (!this._spaceCache.isClosed()) {
                    boolean isHealthy = this._spaceCache.getRemoteProxy().getProxyRouter().getAnyActiveSpace() != null;
                    if (!isHealthy) continue;
                    this._disconnectTime = 0L;
                    break;
                }
            }
            catch (Exception ex) {
                if (!this._logger.isLoggable(Level.WARNING)) break block3;
                this._logger.log(Level.WARNING, "Unexpected error at NotifySpaceCacheStateListener: " + ex.getMessage());
            }
        }
        this._monitorThread = null;
    }
}

