/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.client.SpaceURL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SpaceCacheConfig {
    public static final String FROM_DOTNET = SpaceUrlUtils.toCustomUrlProperty((String)"fromDotNet");
    public static final long DEFAULT_MAX_DISCONNECTION_DURATION = 60000L;
    private final Logger _logger = this.initLogger();
    private Properties _customProperties;
    private SpaceURL _remoteSpaceUrl;
    private Long _maxDisconnectionDuration;
    private Integer _batchSize;
    private Long _batchTimeout;
    private String _storageType;
    private Long _notifyRenewRTT;
    private EntryDataType _entryDataType;

    public SpaceCacheConfig() {
        this(null, new Properties());
    }

    public SpaceCacheConfig(SpaceURL remoteSpaceUrl, Properties customProperties) {
        this._remoteSpaceUrl = remoteSpaceUrl;
        this._customProperties = customProperties;
        this._entryDataType = EntryDataType.USER_TYPE;
    }

    protected abstract Logger initLogger();

    public void initLocalSpaceConfig(SpaceConfigReader configReader) {
        if (this._storageType != null) {
            configReader.setSpaceProperty("dist-cache.storage-type", this._storageType);
        }
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    public void setCustomProperties(Properties customProperties) {
        if (customProperties != null) {
            this._customProperties = customProperties;
        } else {
            this._customProperties.clear();
        }
    }

    public SpaceURL getRemoteSpaceUrl() {
        return this._remoteSpaceUrl;
    }

    public void initRemoteSpaceUrl(IDirectSpaceProxy spaceProxy) {
        if (this._remoteSpaceUrl == null) {
            this._remoteSpaceUrl = spaceProxy.getFinderURL().clone();
            this._remoteSpaceUrl.putAll((Map)this._customProperties);
            this._remoteSpaceUrl.getCustomProperties().putAll((Map<?, ?>)this._customProperties);
        }
        Properties customProperties = this._remoteSpaceUrl.getCustomProperties();
        this._remoteSpaceUrl.setProperty("create", Boolean.FALSE.toString());
        this._remoteSpaceUrl.remove((Object)"useLocalCache");
        if (customProperties != null) {
            customProperties.remove("useLocalCache");
        }
        this._remoteSpaceUrl.remove((Object)"secured");
        if (customProperties != null) {
            customProperties.remove("secured");
        }
        this.applyDefaultValues();
    }

    protected void applyDefaultValues() {
        String value;
        if (this._maxDisconnectionDuration == null) {
            value = this.getDeprecatedProperty("space-config.dist-cache.events.lease", "max-disconnection-duration");
            if (!StringUtils.hasLength((String)value)) {
                value = this.getDeprecatedProperty("space-config.dist-cache.events.lease-renew.duration", "max-disconnection-duration");
            }
            this._maxDisconnectionDuration = StringUtils.hasLength((String)value) ? Long.parseLong(value) : 60000L;
        }
        if (this._batchSize == null) {
            value = this.getDeprecatedProperty("space-config.dist-cache.events.batch.size", "batch-size");
            this._batchSize = StringUtils.hasLength((String)value) ? Integer.parseInt(value) : 1000;
        }
        if (this._batchTimeout == null) {
            value = this.getDeprecatedProperty("space-config.dist-cache.events.batch.timeout", "batch-timeout");
            this._batchTimeout = StringUtils.hasLength((String)value) ? Long.parseLong(value) : 100L;
        }
        if (this._notifyRenewRTT == null) {
            value = this.getUrlProperty("space-config.dist-cache.events.lease-renew.round-trip-time");
            this._notifyRenewRTT = StringUtils.hasLength((String)value) ? Long.parseLong(value) : 10000L;
        }
        if (this._storageType == null) {
            this._storageType = this.getDeprecatedProperty("storageType", null);
            if (this._storageType == null && Boolean.parseBoolean(this.getUrlProperty(FROM_DOTNET))) {
                this.setStorageType("shallowCopy");
            }
        }
    }

    protected String getUrlProperty(String key) {
        String result = this._remoteSpaceUrl.getProperty(key);
        if (!StringUtils.hasLength((String)result)) {
            result = this._remoteSpaceUrl.getCustomProperties().getProperty(key);
        }
        return result;
    }

    protected String getDeprecatedProperty(String key, String alternateProperty) {
        String result = this.getUrlProperty(key);
        if (StringUtils.hasLength((String)result) && this._logger.isLoggable(Level.WARNING)) {
            String message = "Property '" + key + "' is deprecated";
            message = alternateProperty == null ? message + "." : message + " - use '" + alternateProperty + "' with OpenSpaces configurers instead.";
            this._logger.log(Level.WARNING, message);
        }
        return result;
    }

    public void setStorageType(String storageType) {
        this._storageType = storageType;
        this._entryDataType = storageType.equalsIgnoreCase("reference") ? EntryDataType.USER_TYPE : EntryDataType.FLAT;
    }

    public Long getMaxDisconnectionDuration() {
        return this._maxDisconnectionDuration;
    }

    public void setMaxDisconnectionDuration(Long maxDisconnectionDuration) {
        this._maxDisconnectionDuration = maxDisconnectionDuration;
    }

    public Integer getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this._batchSize = batchSize;
    }

    public Long getBatchTimeout() {
        return this._batchTimeout;
    }

    public void setBatchTimeout(Long batchTimeout) {
        this._batchTimeout = batchTimeout;
    }

    public long getNotifyRenewRTT() {
        return this._notifyRenewRTT;
    }

    public abstract boolean isActiveWhileDisconnected();

    public abstract boolean supportsNotifications();

    public EntryDataType getEntryDataType() {
        return this._entryDataType;
    }
}

