/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache;

import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.SpaceCacheState;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheConfig;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.cache.localview.LocalViewConfig;
import com.gigaspaces.internal.client.cache.localview.LocalViewContainer;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceCacheFactory {
    private static final Logger _localViewlogger = Logger.getLogger("com.gigaspaces.localview");
    private static final Logger _localCachelogger = Logger.getLogger("com.gigaspaces.localcache");

    public static LocalCacheContainer createLocalCache(IDirectSpaceProxy remoteSpace, LocalCacheConfig config) throws SpaceInitializationException {
        if (_localCachelogger.isLoggable(Level.FINE)) {
            _localCachelogger.log(Level.FINE, "Starting to create local cache over space " + remoteSpace.getName() + "...");
        }
        long startTime = SystemTime.timeMillis();
        LocalCacheContainer cache = new LocalCacheContainer(remoteSpace, config);
        cache.initialize();
        long finishTime = SystemTime.timeMillis();
        SpaceCacheState cacheState = cache.getCacheState();
        if (cacheState == SpaceCacheState.CONNECTED) {
            if (_localCachelogger.isLoggable(Level.INFO)) {
                _localCachelogger.log(Level.INFO, cache.getCacheId() + " was created successfully. Total time: " + JSpaceUtilities.formatMillis((long)(finishTime - startTime)));
            }
        } else if (cacheState == SpaceCacheState.DISCONNECTED && _localCachelogger.isLoggable(Level.WARNING)) {
            _localCachelogger.log(Level.WARNING, cache.getCacheId() + " was created in DISCONNECTED state. Total time: " + JSpaceUtilities.formatMillis((long)(finishTime - startTime)));
        }
        return cache;
    }

    public static AbstractSpaceCacheContainer createLocalView(IDirectSpaceProxy remoteSpace, LocalViewConfig config) throws SpaceInitializationException {
        if (_localViewlogger.isLoggable(Level.FINE)) {
            _localViewlogger.log(Level.FINE, "Starting to create local view over space " + remoteSpace.getName() + "...");
        }
        long startTime = SystemTime.timeMillis();
        LocalViewContainer cache = new LocalViewContainer(remoteSpace, config);
        cache.initialize();
        long finishTime = SystemTime.timeMillis();
        SpaceCacheState cacheState = cache.getCacheState();
        if (cacheState == SpaceCacheState.CONNECTED) {
            if (_localViewlogger.isLoggable(Level.INFO)) {
                _localViewlogger.log(Level.INFO, cache.getCacheId() + " was created successfully. Total time: " + JSpaceUtilities.formatMillis((long)(finishTime - startTime)));
            }
        } else if (cacheState == SpaceCacheState.DISCONNECTED && _localViewlogger.isLoggable(Level.WARNING)) {
            _localViewlogger.log(Level.WARNING, cache.getCacheId() + " was created in DISCONNECTED state. Total time: " + JSpaceUtilities.formatMillis((long)(finishTime - startTime)));
        }
        return cache;
    }

    public static ISpaceProxy createSpaceCache(IDirectSpaceProxy remoteSpace, Properties customProperties, SpaceURL remoteSpaceUrl) throws SpaceInitializationException {
        if (remoteSpaceUrl.containsKey((Object)"views") || remoteSpaceUrl.getCustomProperties().containsKey("views")) {
            if (_localViewlogger.isLoggable(Level.WARNING)) {
                _localViewlogger.log(Level.WARNING, "Creating a local view using a url is deprecated. use LocalViewSpaceConfigurer or LocalViewSpaceFactoryBean instead.");
            }
            LocalViewConfig viewConfig = new LocalViewConfig(remoteSpaceUrl, customProperties, SpaceCacheFactory.extractViewTemplatesFromUrl(remoteSpaceUrl));
            return SpaceCacheFactory.createLocalView(remoteSpace, viewConfig);
        }
        return SpaceCacheFactory.createLocalCache(remoteSpace, new LocalCacheConfig(remoteSpaceUrl, customProperties));
    }

    private static List<Object> extractViewTemplatesFromUrl(SpaceURL url) throws SpaceInitializationException {
        Object viewsUrl;
        ArrayList<Object> result = new ArrayList<Object>();
        Object viewsCustom = url.getCustomProperties().remove("views");
        if (viewsCustom != null) {
            if (viewsCustom instanceof Object[]) {
                Object[] views;
                for (Object view : views = (Object[])viewsCustom) {
                    result.add(view);
                }
            } else if (viewsCustom instanceof SQLQuery) {
                result.add(viewsCustom);
            } else {
                throw new SpaceInitializationException("Failed to get views property - value should be a View or a View array.");
            }
        }
        if ((viewsUrl = url.remove((Object)"views")) != null) {
            if (!(viewsUrl instanceof String)) {
                throw new SpaceInitializationException("Failed to get views property - value is not a string.");
            }
            String viewsString = (String)viewsUrl;
            if (viewsString.startsWith("{")) {
                viewsString = viewsString.substring(1);
            }
            if (viewsString.endsWith("}")) {
                viewsString = viewsString.substring(0, viewsString.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(viewsString, ",");
            while (st.hasMoreTokens()) {
                String query = st.nextToken();
                String[] splits = query.split(":");
                result.add(new SQLQuery(splits[0], splits.length > 1 ? splits[1] : null));
            }
        }
        if (result.isEmpty()) {
            throw new SpaceInitializationException("View templates must be provided when LocalViewImpl is created");
        }
        return result;
    }
}

