/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache;

import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.time.SystemTime;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

public class GarbageCollectorTask
implements Runnable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.localcache");
    public static final int TIME_TO_SLEEP = 3000;
    private final WeakReference<Map<String, LocalCacheContainer.GCEntry>> _weakBlockEntries;

    public GarbageCollectorTask(Map<String, LocalCacheContainer.GCEntry> blockEntries) {
        this._weakBlockEntries = new WeakReference<Map<String, LocalCacheContainer.GCEntry>>(blockEntries);
    }

    @Override
    public void run() {
        Map blockEntries = (Map)this._weakBlockEntries.get();
        if (blockEntries == null || blockEntries.isEmpty()) {
            return;
        }
        HashSet<ServerTransaction> staleXtn = null;
        Iterator iter = blockEntries.values().iterator();
        while (iter.hasNext()) {
            boolean getStateException;
            int xtnState;
            LocalCacheContainer.GCEntry gcEntry;
            block7: {
                gcEntry = (LocalCacheContainer.GCEntry)iter.next();
                if (gcEntry._xtn == null) {
                    if (SystemTime.timeMillis() <= gcEntry._ttl + 1000L) continue;
                    iter.remove();
                    continue;
                }
                xtnState = 0;
                getStateException = false;
                if (staleXtn == null) {
                    staleXtn = new HashSet<ServerTransaction>();
                }
                try {
                    if (staleXtn.contains(gcEntry._xtn)) {
                        iter.remove();
                        continue;
                    }
                    xtnState = gcEntry._xtn.getState();
                }
                catch (Exception ex) {
                    getStateException = true;
                    if (!_logger.isLoggable(Level.FINE)) break block7;
                    _logger.log(Level.FINE, "GarbageCollector: Xtn getState() failed", ex);
                }
            }
            if (!getStateException && xtnState == 1) continue;
            staleXtn.add(gcEntry._xtn);
            iter.remove();
        }
    }
}

