/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache;

import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.cache.CustomInfo;
import com.gigaspaces.internal.client.cache.NotifySpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.localcache.GarbageCollectorTask;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheInfo;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheListener;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheLockManager;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.kernel.ScheduledRunner;
import com.j_spaces.kernel.weaklistener.WeakBatchRemoteEventListener;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;

public class LocalCache
extends NotifySpaceCache {
    private final LocalCacheContainer _cacheContainer;
    private final LocalCacheLockManager _lockManager;
    private final LocalCacheListener _cacheListener;
    private final ConcurrentMap<String, LocalCacheContainer.GCEntry> _blockEntries;
    private final ScheduledRunner _gcTaskRunner;

    public LocalCache(LocalCacheContainer cacheContainer) {
        super(cacheContainer);
        this._remoteSpace.setOptimisticLocking(true);
        this._cacheContainer = cacheContainer;
        this._lockManager = new LocalCacheLockManager();
        this._cacheListener = new LocalCacheListener(this);
        this._blockEntries = new ConcurrentHashMap<String, LocalCacheContainer.GCEntry>();
        this._gcTaskRunner = new ScheduledRunner((Runnable)new GarbageCollectorTask(this._blockEntries), 3000L, 3000L);
    }

    @Override
    public void initialize() throws SpaceInitializationException, InterruptedException {
        super.initialize();
        if (this._eventSession != null) {
            this.initEventListeners();
        }
    }

    @Override
    public void close() {
        block3: {
            try {
                if (this._gcTaskRunner != null) {
                    this._gcTaskRunner.cancel();
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.FINE)) break block3;
                this._logger.log(Level.FINE, "Failed to cancel gc task runner", e);
            }
        }
        super.close();
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localcache");
    }

    public int getUpdateMode() {
        return this._cacheContainer.getCacheConfig().getUpdateMode();
    }

    public long getMaxTimeToLive() {
        return this._cacheContainer.getCacheConfig().getMaxTimeToLive();
    }

    @Override
    protected boolean useFifoEventListeners() {
        return false;
    }

    private void initEventListeners() throws SpaceCacheInitializationException {
        WeakBatchRemoteEventListener weakListener = new WeakBatchRemoteEventListener((BatchRemoteEventListener)this._cacheListener);
        NotifyActionType notifyType = NotifyActionType.NOTIFY_UPDATE.or(NotifyActionType.NOTIFY_TAKE);
        NotifyInfo notifyInfo = this._eventSession.createNotifyInfo((RemoteEventListener)weakListener, notifyType).setReturnOnlyUids(true).setCustomInfo((CustomInfo)new LocalCacheInfo());
        try {
            this._eventSession.addListener(new Object(), Long.MAX_VALUE, notifyInfo);
        }
        catch (RemoteException e) {
            throw new SpaceCacheInitializationException("Failed to register local cache data event listener.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToCache(IEntryPacket ep, Object objectToUpdateWith, int updateModifiers, long readUpdateTime, boolean fromUpdate, long lease) throws RemoteException, EntryVersionConflictException {
        int txnState;
        LocalCacheContainer.GCEntry gcEntry;
        String uid = ep.getUID();
        Object lock = null;
        Object object = lock = this._lockManager.aquireLock(uid);
        synchronized (object) {
            gcEntry = (LocalCacheContainer.GCEntry)this._blockEntries.get(uid);
            if (gcEntry != null && gcEntry._xtn == null && readUpdateTime > gcEntry.getInsertionTime()) {
                this._blockEntries.remove(uid);
                gcEntry = null;
            }
            if (gcEntry == null) break block27;
            if (gcEntry._xtn == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 25, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var11_9
                if (lock == null) return;
                this._lockManager.releaseLock(lock);
                return;
            }
            txnState = 1;
        }
        {
            IDirectSpaceProxy localSpace;
            int version;
            long ttl;
            block28: {
                block27: {
                    try {
                        txnState = gcEntry._xtn.getState();
                    }
                    catch (UnknownTransactionException e) {
                        txnState = 5;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (txnState != 5 && txnState != 6) {
                        // MONITOREXIT @DISABLED, blocks:[24, 10] lbl27 : MonitorExitStatement: MONITOREXIT : var11_9
                        if (lock == null) return;
                        this._lockManager.releaseLock(lock);
                        return;
                    }
                    this._blockEntries.remove(uid);
                }
                ttl = lease;
                if (!fromUpdate && (ttl = Math.min(ep.getTTL(), this.getMaxTimeToLive())) == 0L) {
                    ttl = this.getMaxTimeToLive();
                }
                version = ep.getVersion();
                localSpace = this._localSpace;
                if (localSpace == null) {
                    // MONITOREXIT @DISABLED, blocks:[5, 22, 10] lbl40 : MonitorExitStatement: MONITOREXIT : var11_9
                    if (lock == null) return;
                    this._lockManager.releaseLock(lock);
                    return;
                }
                if (ttl >= 0L) break block28;
                // MONITOREXIT @DISABLED, blocks:[5, 10] lbl45 : MonitorExitStatement: MONITOREXIT : var11_9
                if (lock == null) return;
                this._lockManager.releaseLock(lock);
                return;
            }
            try {
                try {
                    localSpace.update(objectToUpdateWith, null, ttl, 0L, updateModifiers);
                    if (ep != objectToUpdateWith) return;
                    ep.setVersion(version);
                }
                catch (EntryVersionConflictException ex) {
                    if (fromUpdate) {
                        throw ex;
                    }
                    if (!this._logger.isLoggable(Level.FINE)) return;
                    this._logger.log(Level.FINE, "cache(): Ignore because of read concurrency", ex);
                }
                catch (EntryNotInSpaceException ex) {
                    if (!this._logger.isLoggable(Level.FINE)) return;
                    this._logger.log(Level.FINE, "cache(): Ignore because of read concurrency", ex);
                }
                catch (RemoteException e) {
                    Throwable ex = e.getCause();
                    if (!(ex instanceof EntryVersionConflictException)) throw e;
                    if (fromUpdate) {
                        throw (EntryVersionConflictException)ex;
                    }
                    if (!this._logger.isLoggable(Level.FINE)) return;
                    this._logger.log(Level.FINE, "cache(): Ignore because of read concurrency", ex);
                }
                catch (Exception e) {
                    throw new RemoteException("fail while caching", e);
                }
                return;
            }
            finally {
                if (lock != null) {
                    this._lockManager.releaseLock(lock);
                }
            }
        }
    }

    public void addToCache(IEntryPacket entry, int updateModifiers, long readUpdateTime) throws RemoteException {
        try {
            this.addToCache(entry, entry, updateModifiers, readUpdateTime, false, 0L);
        }
        catch (EntryVersionConflictException entryVersionConflictException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String uid, Transaction txn, boolean disableInsertions) {
        Object lock = null;
        try {
            Object object = lock = this._lockManager.aquireLock(uid);
            synchronized (object) {
                IDirectSpaceProxy localSpace;
                block13: {
                    if (disableInsertions) {
                        this._blockEntries.put(uid, new LocalCacheContainer.GCEntry(SystemTime.timeMillis(), txn));
                    }
                    if ((localSpace = this._localSpace) != null) break block13;
                    return;
                }
                localSpace.takeByUid(uid, null, localSpace.getReadModifiers(), QueryResultTypeInternal.NOT_SET, true);
            }
        }
        catch (Exception ex) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "Failed to remove entry from local cache (uid=" + uid + ").", ex);
            }
        }
        finally {
            if (lock != null) {
                this._lockManager.releaseLock(lock);
            }
        }
    }

    public void updateCache(IEntryPacket updatedPacket, Object objectToUpdateWith, Transaction txn, long lease, int updateModifiers, long updateTime) {
        block7: {
            try {
                if (txn == null) {
                    this.addToCache(updatedPacket, objectToUpdateWith, UpdateModifiers.isPartialUpdate((int)updateModifiers) ? 16 : 8, updateTime, true, lease);
                } else {
                    this.removeFromCache(updatedPacket.getUID(), txn, true);
                }
            }
            catch (EntryVersionConflictException ex) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "updateLocals: ", ex);
                }
                if (txn == null && UpdateModifiers.isPartialUpdate((int)updateModifiers)) {
                    this.removeFromCache(updatedPacket.getUID(), txn, false);
                }
            }
            catch (Exception e) {
                if (!this._logger.isLoggable(Level.FINE)) break block7;
                this._logger.log(Level.FINE, "updateLocals: ", e);
            }
        }
    }

    public void updateCache(IEntryPacket updatedPacket, Transaction transaction, long lease, int updateModifiers, long updateTime) {
        this.updateCache(updatedPacket, updatedPacket, transaction, lease, updateModifiers, updateTime);
    }

    public void cleanBlockedEntries() {
        this._blockEntries.clear();
    }
}

