/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache;

import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.client.SpaceURL;
import java.util.Properties;
import java.util.logging.Logger;

public class LocalCacheConfig
extends SpaceCacheConfig {
    private Long _maxTimeToLive;
    private Integer _updateMode;

    public LocalCacheConfig() {
    }

    public LocalCacheConfig(SpaceURL remoteSpaceUrl, Properties customProperties) {
        super(remoteSpaceUrl, customProperties);
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localcache");
    }

    @Override
    protected void applyDefaultValues() {
        String value;
        super.applyDefaultValues();
        if (this._maxTimeToLive == null) {
            value = this.getDeprecatedProperty("space-config.dist-cache.max-object-timeout", "time-to-live");
            this._maxTimeToLive = StringUtils.hasLength((String)value) ? Long.parseLong(value) : 300000L;
        }
        if (this._updateMode == null) {
            value = this.getDeprecatedProperty("updateMode", "update-mode");
            if (StringUtils.hasLength((String)value)) {
                this._updateMode = Integer.parseInt(value);
            } else {
                value = this.getDeprecatedProperty("space-config.dist-cache.events.enabled", "update-mode");
                boolean notificationsEnabled = StringUtils.hasLength((String)value) ? Boolean.parseBoolean(value) : true;
                this._updateMode = notificationsEnabled ? 1 : 0;
            }
        }
    }

    @Override
    public void initLocalSpaceConfig(SpaceConfigReader configReader) {
        super.initLocalSpaceConfig(configReader);
        configReader.setSpaceProperty("lease_manager.disable_entries_leases", "false");
    }

    public Long getMaxTimeToLive() {
        return this._maxTimeToLive;
    }

    public void setMaxTimeToLive(Long maxTimeToLive) {
        this._maxTimeToLive = maxTimeToLive;
    }

    public Integer getUpdateMode() {
        return this._updateMode;
    }

    public void setUpdateMode(Integer updateMode) {
        this._updateMode = updateMode;
    }

    public void setSize(int size) {
        this.getCustomProperties().setProperty("space-config.engine.cache_size", Integer.toString(size));
    }

    @Override
    public boolean supportsNotifications() {
        return this._updateMode != 0;
    }

    @Override
    public boolean isActiveWhileDisconnected() {
        return true;
    }
}

